<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AddAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        
        if (isset($_POST['subject']))
    	{
    		$subject = $this->getController()->filter(S::gp('subject','P'));
    		$content = $this->getController()->filter(S::gp('content','P'));
    		$sort = S::gp('sort','P',2);
    		
    		$count = $this->db()->getValue('SELECT COUNT(*) as count FROM '.BookStick::table()." WHERE forumid = '{$this->id()}'");
    		if ($count > 3)
    		{
    			throw new iSystemException('一个书会最多只能添加3条置顶贴');
    		}
    		if (empty($subject) || empty($content))
    		{
    			throw new iSystemException('请填写完整信息');
    		}
    		if (4 > mb_strlen($subject, 'utf8') || 100 < mb_strlen($subject, 'utf8'))
    		{
    			throw new iSystemException('标题长度不能小于4个字或者大于100个字');
    		}
    		
    		if (4 > mb_strlen($subject, 'utf8') || 10000 < mb_strlen($subject, 'utf8'))
    		{
    			throw new iSystemException('内容长度不能小于4个字或者大于10000个字');
    		}
    		
    		$data = array(
    			'uid' => $this->uid(),
    			'username' => $this->userName(),
    			'forumid' => $this->id(),
    			'subject' => $subject,
    			'content' => $content,
    			'sort' => $sort,
    			'createdate' => date('Y-m-d H:i:s'),
    		);
    		$this->db()->insert(BookStick::table())->value($data)->q();
    		updateForumStick($this->id());
    		
    		$message[] = '置顶贴添加成功';
    		$message[] = '返回'.ilink('管理',url('system',array('s'=>'forum','c'=>'manage','id'=>$this->id()))).'.'.forumLink($this->id());
    		$this->showMessage($message);
    	}
    	else
    	{
    	    throw new iSystemException('非法访问');
    	}
    }
}