<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class EditAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        
        $tid = S::gp('tid','G',2);
        $stick = $this->db()->select()->from(BookStick::table())->where(array('id'=>$tid))->find(true);
        if (empty($stick))
        {
            throw new iSystemException('不存在的公告');
        }
        
        if (isset($_POST['subject']))
    	{
    		$subject = $this->getController()->filter(S::gp('subject','P'));
    		$content = $this->getController()->filter(S::gp('content','P'));
    		$sort = S::gp('sort','P',1);
    		
    		if (empty($subject) || empty($content))
    		{
    			throw new iSystemException('请填写完整信息');
    		}
    		if (4 > mb_strlen($subject, 'utf8') || 100 < mb_strlen($subject, 'utf8'))
    		{
    			throw new iSystemException('标题长度不能小于4个字或者大于100个字');
    		}
    		
    		if (4 > mb_strlen($subject, 'utf8') || 10000 < mb_strlen($subject, 'utf8'))
    		{
    			throw new iSystemException('内容长度不能小于4个字或者大于10000个字');
    		}
    		$data = array(
    			'uid' => $this->uid(),
    			'username' => $this->userName(),
    			'subject' => $subject,
    			'content' => $content,
    			'sort' => $sort,
    			'updatedate' => date('Y-m-d H:i:s'),
    		);
    		
    		$this->db()->update(BookStick::table())->value($data)->where(array('id'=>$tid))->q();
    		updateForumStick($this->id());
    		
    		$message[] = '置顶贴修改成功';
         	$message[] = '返回'.ilink('管理',url('system',array('s'=>'forum','c'=>'manage','id'=>$this->id()))).'.'.forumLink($this->id());
         	$this->showMessage($message);
    	}
    	
    	$this->getController()->render('edit', array(
    	        'bookid' => $this->id(),
    	        'stick' => $stick,
    	    )
    	);
    }
}