<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class FavoriteListAction extends MemberAction
{
    public function run()
    {
        $bookId = S::gp('bid', 'G', 2);
        $book = fetchBookInfo($bookId);
        if (empty($book))
        {
            throw new iSystemException('不存在的小说');
        }

        $count = $this->db()->getValue('SELECT COUNT(*) FROM '.Favorites::table().' WHERE bid = '.S::sqlEscape($bookId));
        $pageObj = new iPage();
        $pageObj->setPageSize(10);
        $pageObj->setTotalRecord($count);

        $sql = 'SELECT memberid FROM '.Favorites::table().' WHERE bid='.S::sqlEscape($bookId).' '.S::sqlLimit($pageObj->getOffset(), $pageObj->getPageSize());
        $members = $this->db()->setQueryString($sql)->find();
        $uList = $result = array();
        if (!empty($members))
        {
            foreach ($members as $member)
            {
                $uList[] = $member['memberid'];
            }
            $sql = 'SELECT username,uid FROM '.Members::table().' WHERE uid IN (' . implode(',', $uList) . ')';
            $result = $this->db()->setQueryString($sql)->find();
        }

        $this->getController()->render('favoritelist', array('pageObj'=>$pageObj, 'result'=>$result, 'book'=>$book));
    }
}
