<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ProgressAction extends MemberAction
{
    public function run()
    {
        $bookid = S::gp('bid','G', 2);
        $chapterid = S::gp('cid', 'G', 2);
        $subpage = $_GET['sp'] ? S::gp('sp', 'G', 2) : 1;
        
        empty($bookid) && $this->_showMessage('非法操作，请返回');
        $book = fetchBookInfo($bookid);
        empty($book) && $this->_showMessage('不存在的小说');

        $iorange = $this->iorange();
        $eMessage = '您目前已经保存了'.u('bnum').'条进度，而您当前等级只允许保存'.$iorange['user']['group']['booklimit'].'条，您可以通过删除多余进度或者提升等级来获得更多的保存数量！';
        if (u('bnum') > $iorange['user']['group']['booklimit'])
        {
            $this->_showMessage($eMessage);
        }
        else if (u('bnum') == $iorange['user']['group']['booklimit'])
        {
            $check = $this->db()->getValue('SELECT COUNT(*) FROM '.Favorites::table().' WHERE memberid='.S::sqlEscape($this->uid()) . ' AND bid='.S::sqlEscape($bookid));
            if (!$check)
            {
                $this->_showMessage($eMessage);
            }
        }
        
        $saveArray = array(
            'memberid' => $this->uid(),
            'bid' => $bookid,
            'cid' => $chapterid,
            'sp' => $subpage,
            'createdate' => CDATETIME
        );
        Favorites::single()->save($saveArray);
        setCookieValue('lrb'.$this->uid(), $bookid.'|'.$chapterid.'|'.$subpage, CTIME + 2 * 3600, '/');

        if ($this->getController()->isAjaxRequest())
        {
            die(json_encode(array('status' => 1, 'msg' => '保存成功')));
        }
        
        $message[] = '阅读进度保存成功,下次登录书房后可以快速进入进度列表进行阅读';
        if (!isWebRequest() && (empty($iorange['user']['autoprogress']) || $iorange['user']['autoprogress'] < $_SERVER['REQUEST_TIME']))
        {
            $message[] = '如果您不想每次都手动进行保存,可以使用全智能'.ilink('自动保存进度功能',url('system',array('s'=>'props','c'=>'auto')));
        }
        $message[] = '返回'.ilink('我的进度',url('system',array('s'=>'member','c'=>'my','a'=>'progress'))).'.'.memberLink().'.'.indexLink();
        
        $this->showMessage($message);
    }
}