<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ReportAction extends MemberAction
{
    public function run()
    {
        $bookId = S::gp('bid','G', 2);
        $chapterId = S::gp('cid','G', 2);
        $book = fetchBookInfo($bookId);
        
        if (empty($book))
        {
            throw new iSystemException('不存在的小说');
        }
        
        if (2 != $book['type'])
        {
            throw new iSystemException('非原创小说不能举报');
        }
        
        $check = $this->db()->getValue('SELECT COUNT(*) FROM '.Oreports::table().' WHERE uid='.$this->uid().' AND cid='.$chapterId);
        if ($check)
        {
            throw new iSystemException('您已经举报过本章节，请不要重复提交！');
        }
        $typeList = Oreports::$type;
        
        if (isset($_POST['type']))
        {
            $type = S::gp('type', 'P', 2);
            $remark = S::gp('remark', 'P');
            if (!key_exists($type, $typeList))
            {
                throw new iSystemException('非法请求');
            }
            
            $chapter = Chapter::single()->getOne($chapterId);
            $authorName = $book['author'];
            $authorId = Authors::single()->getAuthorId($authorName);
            $url = staticUrl('read',array('bid'=>$bookId,'cid'=>$chapterId));
            $this->db()->insert(Oreports::table())->value(array('aid'=>$authorId,'author'=>$authorName,'uid'=>$this->uid(),'username'=>$this->userName(),'bid'=>$bookId,'bookname'=>$book['bookname'],'chaptername'=>$chapter['chaptername'],'cid'=>$chapterId,'createdate'=>CDATETIME,'date'=>CDATE,'remark'=>$remark,'url'=>$url,'type'=>$typeList[$type]))->q();
            $message[] = '感谢您的举报,我们将尽快处理！';
            $message[] = '返回'.ilink('继续阅读',url('read',array('bid'=>$bookId,'cid'=>$chapterId))).'.'.memberLink();
            $this->showMessage($message);
        }

        $this->getController()->render('report', array('typeList' => $typeList, 'bookId' => $bookId, 'chapterId' => $chapterId));
    }
}