<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class TippingAction extends MemberAction
{
    public function run()
    {
        $iorange = $this->iorange();
        $bookid = S::gp('bid','G', 2);
        $book = fetchBookInfo($bookid);

        if (empty($book))
        {
            throw new iSystemException('不存在的小说');
        }
        if (!Book::isOriginal($book['type']))
        {
            throw new iSystemException('非本站原创小说不能打赏');
        }
        if (!$book['tipping'])
        {
            throw new iSystemException('此书禁止打赏');
        }
        if ($book['size'] < 100000)
        {
            throw new iSystemException('不足10W字的原创小说不能打赏');
        }
        if (!u('verify'))
        {
            throw new iSystemException('未验证会员禁止打赏');
        }
        
        if (isset($_POST['num']))
        {
            $num = S::gp('num', 'P', 2);
            $msg = S::gp('message', 'P');
            if ($num < 10)
            {
                throw new iSystemException('打赏的金额不能小于10');
            }
            if (mb_strlen($msg, 'utf-8') > 150)
            {
                throw new iSystemException('留言不能超过150个字');
            }
            
            $maxTipping = BookTipping::getMaxTipping($book['size']);
            if ($maxTipping < ($num + BookTipping::single()->userTodayTipping($this->uid(), $bookid)))
            {
                throw new iSystemException('当前小说没人每天最多打赏'.$maxTipping.setting('creditname'));
            }
        
            try
            {
                Members::single()->hasMoney($this->uid(), $num);
            }
            catch (NotEnoughMoneyException $exce)
            {
                throw new iSystemException('您的'.setting('creditname').'不足'.$num.',不能打赏');
            }
        
            $author = $this->db()->select(array('uid'))->from(Authors::table())->where(array('name'=>$book['author']))->find(true);
            $authorId = $author['uid'];
            
            if (!$authorId)
            {
                throw new iSystemException('很抱歉，此书的作者信息有问题，请联系管理员反应情况，感谢您的支持！');
            }
            $authorName = userName($authorId);

            $creditObj = iCredits::single($authorId, $authorName);
            $creditObj->setUid($authorId);
            $creditObj->setUserName($authorName);
            $creditObj->addMoney($num, false);
            
            $creditObj->log($authorId, $authorName, $num);
        
            $creditObj->setUid($this->uid());
            $creditObj->setUserName($this->userName());
            $creditObj->consume($num);

            $msg = !empty($msg) ? '【书友留言】: '.$msg : '';
            $subject = '[系统消息]您的小说《'.$book['bookname'].'》获得书友打赏';
            $content = '恭喜!您的作品《'.$book['bookname'].'》获得书友'.$this->userName().'认可,给您打赏了'.setting('creditname').$num.", 请继续努力写作以感谢支持你的书友吧!\n".$msg;
            Members::sendMessage($subject, $content, 1, 'admin', $authorId);
        
            $data = array(
                'uid' => $this->uid(),
                'username' => $this->userName(),
                'message' => '[系统消息]书友'.$this->userName().'打赏作者'.$num.setting('creditname').$msg,
        
            );
            BookPost::single()->create($bookid, $data);
        
            $feed = '{{'.$this->uid().'}}打赏了[url='.staticUrl('bookshow',array('bid'=>$bookid)).']《'.$book['bookname'].'》[/url]'.$num.setting('creditname');
            iFeed::single()->create($feed, $this->uid(), 'book');
            
            $tipping = array(
                'uid' => $this->uid(),
                'username' => $this->userName(),
                'bookid' => $bookid,
                'num' => $num,
                'date' => CDATE,
                'createdate' => CDATETIME,
            );
            $this->db()->insert(BookTipping::table())->value($tipping)->q();
        
            $message[] = '打赏成功';
            $message[] = '返回'.ilink('书页', url('bookshow',array('bid'=>$bookid))).'.'.ilink('书会', url('system',array('s' => 'forum', 'id' => $bookid))).'.'.memberLink();
            $this->showMessage($message);
        }
        
        $this->getController()->render('tipping',array(
        		'iorange'=>$iorange,
                'bookid' => $bookid,
            )
        );
    }
}