<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AddAction extends MemberAction
{
    public function run()
    {
        $typeList = $this->db()->select()->from(DiaryType::table())->where('uid='.S::sqlEscape($this->uid()))->find();
        
        if (isset($_POST['subject']))
        {
            $subject = S::gp('subject','P');
            $content = S::gp('content','P');
            $type = S::gp('type','P',2);
            $privacy = S::gp('privacy','P',2);
            $password = S::gp('password','P');
            $abstract = S::gp('abstract','P');
            $toped = S::gp('toped','P',2);
            $comment = S::gp('comment','P',2);
            
            if ($type)
            {
                $checkType = $this->db()->getValue('SELECT COUNT(*) FROM '.DiaryType::table().' WHERE uid='.S::sqlEscape($this->uid()).' AND id='.S::sqlEscape($type));
                if (!$checkType)
                {
                    throw new iSystemException('不正确的分类');
                }
            }
            if ($password && 10 < mb_strlen($password,'utf-8'))
            {
                throw new iSystemException('访问密码不能大于10个字');
            }
            if (empty($subject) || 8 > mb_strlen($subject,'utf-8') || 150 < mb_strlen($subject,'utf-8'))
            {
                throw new iSystemException('标题长度不能小于8个字或者大于150个字');
            }
            if (empty($content))
            {
                throw new iSystemException('请输入日志内容');
            }
            if ($abstract && 200 < mb_strlen($abstract,'utf-8'))
            {
                throw new iSystemException('摘要长度不能大于200个字');
            }
            if (!$abstract)
            {
                $abstract = mb_substr($content, 0, 50, 'utf-8');
            }
            $data = array(
                'uid' => $this->uid(),
                'tid' => $type,
                'privacy' => $privacy,
                'subject' => $subject,
                'abstract' => $abstract,
                'password' => $password,
                'istoped' => $toped,
                'iscomment' => $comment,
                'createdate' => CTIME,
            );
            $this->db()->insert(Diary::table())->value($data)->q();
            $did = $this->db()->getInsertId();
            if (!$did)
            {
                throw new iSystemException('新增加日志失败，请返回重试');
            }
            
            $this->db()->insert(DiaryData::table())->value(array('did'=>$did,'content'=>$content,'createdate'=>CTIME))->q();
            $this->db()->update(Memberfields::table())->incrField(array('diaries'=>1))->where('uid='.S::sqlEscape($this->uid()))->q();
            if ($type)
            {
                $this->db()->update(DiaryType::table())->incrField(array('num'=>1))->where('id='.S::sqlEscape($type))->q();
            }
            
            $feed = '{{'.$this->uid().'}}发表了日志[url='.staticUrl('system',array('s'=>'member','c'=>'diary','a'=>'read','id'=>$did)).']《'.$subject.'》[/url]';
            iFeed::single()->create($feed, $this->uid(), 'member');
            iforward(url('system',array('s'=>'member','c'=>'diary','a'=>'read','id'=>$did)));
        }
        
        $this->getController()->render('add',array(
                'typeList' => $typeList,
            )
        );
    }
}