<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CommentAction extends MemberAction
{
    public function run()
    {
        if (!isset($_POST['comment']))
        {
            throw new iSystemException('非法访问，请返回');
        }
        
        $id = S::gp('id','G',2);
        $f = S::gp('f','G',2);
        $content = S::gp('comment');
        
        $diary = $this->db()->select()->from(Diary::table())->where('id='.S::sqlEscape($id))->find(true);
        if (empty($diary))
        {
            throw new iSystemException('不存在的日志');
        }
        
        if (!$diary['iscomment'])
        {
            throw new iSystemException('本日志禁止评论');
        }
        else if (1 == $diary['iscomment'] && !isGM() && $this->uid() != $diary['uid'])
        {
            if (!Friends::single()->isFriend($this->uid(), $diary['uid']))
            {
                throw new iSystemException('本日志只有作者好友才能阅读');
            }
        }
        
        if (empty($content))
        {
            throw new iSystemException('留言不能为空');
        }
        
        if (8 > mb_strlen($content, 'utf-8') || 200 < mb_strlen($content, 'utf-8'))
        {
            throw new iSystemException('留言长度不能小于8或者答应200个字');
        }
        
        $this->db()->insert(DiaryComment::table())->value(array('uid'=>$this->uid(),'content'=>$content,'createdate'=>CTIME,'did'=>$id))->q();
        $this->db()->update(Diary::table())->incrField(array('comments'=>1))->where('id='.S::sqlEscape($id))->q();
        $f ? $merge = array('a'=>'comments') : $merge = array('a'=>'read');
        $forward = url('system',array_merge(array('s'=>'member','c'=>'diary','id'=>$id),$merge));
        
        $feed = '{{'.$this->uid().'}}评论了日志[url='.staticUrl('system',array('s'=>'member','c'=>'diary','a'=>'read','id'=>$id)).']《'.$diary['subject'].'》[/url]';
        iFeed::single()->create($feed, $this->uid());
        
        iforward($forward);
    }
}