<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CommentsAction extends MemberAction
{
    public function run()
    {
        $id = S::gp('id','G',2);
        $diary = $this->db()->select()->from(Diary::table())->where('id='.S::sqlEscape($id))->find(true);
        if (empty($diary))
        {
            throw new iSystemException('不存在的日志');
        }
        
        $count = $this->db()->getValue('SELECT COUNT(*) FROM '.DiaryComment::table().' WHERE did='.S::sqlEscape($id));
        $pageObj = new iPage();
        $pageObj->setPageSize(10);
        $pageObj->setTotalRecord($count);
        
        $sql = 'SELECT * FROM '.DiaryComment::table().' WHERE did='.S::sqlEscape($id).' ORDER BY id DESC '.S::sqlLimit($pageObj->getOffset(),$pageObj->getPageSize());
        $comments = $this->db()->setQueryString($sql)->find();
        if (!empty($comments))
        {
            foreach ($comments as &$comment)
            {
                $comment['username'] = Members::single()->getNameByUid($comment['uid']);
                $comment['content'] = BookPost::filter($comment['content']);
            }
        }
        $floor = $pageObj->getFloor();
        
        $this->getController()->render('comments',array(
                'id' => $id,
                'diary' => $diary,
                'comments' => $comments,
                'pageObj' => $pageObj,
                'floor' => $floor,
            )
        );
    }
}