<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ReadAction extends MemberAction
{
    public function run()
    {
        $id = S::gp('id','G',2);
        $sql = 'SELECT d.*,dt.name,dd.content FROM '.Diary::table().' AS d INNER JOIN '.DiaryData::table().' AS dd ON d.id = dd.did LEFT JOIN '.DiaryType::table().' AS dt ON dt.id = d.tid WHERE d.id='.S::sqlEscape($id);
        $diary = $this->db()->setQueryString($sql)->find(true);
        if (empty($diary))
        {
            throw new iSystemException('不存在的日志');
        }
        
        $this->_checkRead($diary);
        
        if (!isset($_SESSION['user']['diary']['read'][$id]))
        {
            $_SESSION['user']['diary']['read'][$id] = 1;
            $feed = '{{'.$this->uid().'}}阅读了日志[url='.staticUrl('system',array('s'=>'member','c'=>'diary','a'=>'read','id'=>$id)).']《'.$diary['subject'].'》[/url]';
            iFeed::single()->create($feed, $this->uid());
        }

        if ($diary['iscomment'])
        {
            $sql = 'SELECT * FROM '.DiaryComment::table().' WHERE did='.S::sqlEscape($id).' ORDER BY id DESC LIMIT 5';
            $comments = $this->db()->setQueryString($sql)->find();
            if (!empty($comments))
            {
                foreach ($comments as &$comment)
                {
                    $comment['username'] = Members::single()->getNameByUid($comment['uid']);
                    $comment['content'] = BookPost::filter($comment['content']);
                }
            }
        }
        $diary['content'] = BookPost::filter($diary['content']);
        $this->db()->update(Diary::table())->incrField(array('views'=>1))->where('id='.S::sqlEscape($id))->q();
        $this->getController()->render('read', array(
        		'id' => $id,
                'diary' => $diary,
                'comments' => $comments,
            )
        );
    }
    
    protected function _checkRead($diary)
    {
        if (isGM())
        {
            return true;
        }
        
        if (2 == $diary['privacy'] && $diary['uid'] != $this->uid())
        {
            throw new iSystemException('私有日志，仅作者本人可阅读');
        }
        else if (1 == $diary['privacy'] && $diary['uid'] != $this->uid())
        {
            if (!Friends::single()->isFriend($this->uid(), $diary['uid']))
            {
                throw new iSystemException('本日志只有作者好友才能阅读');
            }
        }
        
        if ($diary['password'] && $diary['uid'] != $this->uid())
        {
            if (isset($_POST['password']))
            {
                $password = S::gp('password','P');
            }
            if ($password == $diary['password'])
            {
                $_SESSION['user']['diary'][$diary['id']] = $password;
            }
            
            if ($_SESSION['user']['diary'][$diary['id']] != $diary['password'])
            {
                $this->getController()->render('password',array('id'=>$diary['id'],'diary'=>$diary));
                exit(0);
            }
        }
        
        return true;
    }
}