<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class TypeEditAction extends MemberAction
{
    public function run()
    {
        $tid = S::gp('tid','G',2);
        $type = $this->db()->select()->from(DiaryType::table())->where('id='.$tid)->find(true);
        if (empty($type))
        {
            throw new iSystemException('不存在的分类');
        }
        if ($this->uid() != $type['uid'])
        {
            throw new iSystemException('此分类不属于您');
        }
        
        if (isset($_POST['name']))
        {
            $name = S::gp('name','P');
            $privacy = S::gp('privacy','P',2);
            
            if (empty($name) || 2 > mb_strlen($name, 'utf-8') || mb_strlen($name, 'utf-8') > 6)
            {
                throw new iSystemException('分类名长度必须大于等于2或者小于等于6个字');
            }
            $this->db()->update(DiaryType::table())->value(array('name'=>$name,'privacy'=>$privacy))->where('id='.S::sqlEscape($tid))->q();

            iforward(url('system',array('s'=>'member','c'=>'diary','a'=>'type')));
        }
        $this->getController()->render('typeedit',array(
                'tid' => $tid,
                'type' => $type,
            )
        );
    }
}