<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AddAction extends MemberAction
{
    public function run()
    {
        $uid = intval(S::gp('uid','G'));
        $friend = Members::single()->getOne($uid);
        if (empty($friend))
        {
            throw new iSystemException('添加的好友不存在');         
        }
        $row = $this->db()->select()->from(Friends::table())->where(array('uid'=>$this->uid(),'fuid'=>$friend['uid']))->find(true);
        if (!empty($row))
        {
            throw new iSystemException('用户已经在好友列表，请不要重复添加');
        }
        
        if (2 == $friend['fstatus'])
        {
            throw new iSystemException('当前用户拒绝任何人添加好友');
        }
        elseif (1 == $friend['fstatus'])
        {
            if (isset($_POST['remark']))
            {
                $remark = S::gp('remark','P');
                $subject = '[好友系统通知]'.$this->userName().' 请求加您为好友';
                $content = '书友 '.$this->userName().' 请求加您为好友。[br]请求消息: '.$remark.'[br][br]是否[url='.staticUrl('system',array('s'=>'member','c'=>'friend','a'=>'verify','uid'=>$this->uid(),'fuid'=>$uid)).']同意[/url]？[br]提示: 如果不同意，请忽略此短信';
                Members::sendMessage($subject, $content, 1, 'admin', $uid);
                $this->showMessage('请求消息已发送，正在等待好友验证。');
            }
            
            exit($this->getController()->render('verify',array('uid'=>$uid,'friend'=>$friend)));
        }
        
        Friends::single()->create($uid, $this->uid());
        
        $message[] = '恭喜，添加成功！';
        $message[] = '返回'.memberLink().'.'.indexLink();
        $this->showMessage($message);
    }
}