<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class DeleteAction extends BaseAction
{
    public function run()
    {
        $do = S::gp('do','G');
        !in_array($do, array('item','all','unread','read')) && $this->showMessage('非法操作，请返回');
        if (!$_GET['confirm'])
        {
            $message[] = '确定要删除吗？';
            $message[] = ilink('确定', url('system', array('s'=>'member','c'=>'message','a'=>S::gp('a','G'),'do'=>$do,'mid'=>S::gp('mid','G',2),'confirm'=>1))).'|'.ilink('离开', url('system', array('s'=>'member','c'=>'message')));
            $this->showMessage($message);
        }
        
        switch ($do)
        {
            case 'item':
                $this->_deleteItem();
                break;
            case 'all':
                $this->_deleteAll();
                break;
            case 'unread':
                $this->_deleteUnRead();
                break;
            case 'read':
                $this->_deleteRead();
                break;
        }
        
        Message::single()->updateNewCount($this->uid());

        $message[] = '操作成功';
        $message[] = '返回'.ilink('未读短信',url('system',array('s'=>'member','c'=>'message','a'=>'list','do'=>'new'))).'.'.ilink('信箱',url('system',array('s'=>'member','c'=>'message'))).'.'.ilink('书房',url('system',array('s'=>'member')));
        $this->showMessage($message);
    }
    
    private function _deleteItem()
    {
        $mid = S::gp('mid', 'G', 2);
        empty($mid) && $this->showMessage('非法操作，请返回');
        
        $mModel = Message::single();
        try
        {
            $result = $mModel->getOne($mid);
        }
        catch (Exception $exce)
        {
            $this->showMessage($exce->getMessage());
        }
        
        if ($mModel->isGroupMessage($result))
        {
            $this->db()->insert(MessageRelation::table())->value(array('mid'=>$result['mid'],'uid'=>$this->uid(),'type'=>2))->q();
        }
        else
        {
            if ($result['msgtoid'] != $this->uid())
            {
                $this->showMessage('非法操作');
            }
            $this->db()->update($mModel->table())->value(array('isdelete'=>1))->where('mid='.$mid)->q();
        }
    }
    
    private function _deleteAll()
    {
        $mTable = Message::table();
        $mnTable = MessageRelation::table();
        
        $this->db()->update($mTable)->value(array('isdelete'=>1))->where('msgtoid='.$this->uid().' AND isdelete=0')->q();
        $isDeleteGroup = Message::single()->getIsDeleteGroupMessage($this->uid());
        
        $sql = 'SELECT mid FROM '.$mTable.' WHERE msgfromid=1 AND msgtoid=0';
        if (!empty($isDeleteGroup))
        {
            $sql .= ' AND mid NOT IN ('.implode(',',$isDeleteGroup).')';
        }
        $result = $this->db()->setQueryString($sql)->find();
        if (!empty($result))
        {
            foreach ($result as $row)
            {
                $this->db()->insert($mnTable)->value(array('mid'=>$row['mid'],'uid'=>$this->uid(),'type'=>2))->q();
            }
        }
    }
    
    private function _deleteUnRead()
    {
        $mTable = Message::table();
        $mnTable = MessageRelation::table();
        
        $this->db()->update($mTable)->value(array('isdelete'=>1))->where('msgtoid='.$this->uid().' AND isnew = 1')->q();
        $isReadGroup = Message::single()->getIsReadGroupMessage($this->uid());
        $sql = 'SELECT mid FROM '.$mTable.' WHERE msgfromid=1 AND msgtoid=0';
        if (!empty($isReadGroup))
        {
            $sql .= ' AND mid NOT IN ('.implode(',',$isReadGroup).')';
        }
        
        $result = $this->db()->setQueryString($sql)->find();
        if (!empty($result))
        {
            foreach ($result as $row)
            {
                $this->db()->insert($mnTable)->value(array('mid'=>$row['mid'],'uid'=>$this->uid(),'type'=>2))->q();
            }
        }
    }
    
    private function _deleteRead()
    {
        $mTable = Message::table();
        $mnTable = MessageRelation::table();
        
        $this->db()->update($mTable)->value(array('isdelete'=>1))->where('msgtoid='.$this->uid().' AND isdelete=0 AND isnew = 0')->q();
        
        $isReadGroup = Message::single()->getIsReadGroupMessage($this->uid());
        $isDeleteGroup = Message::single()->getIsDeleteGroupMessage($this->uid());
        $diff = array_diff($isDeleteGroup,$isReadGroup);
        
        if (!empty($diff))
        {
            foreach ($diff as $mid)
            {
                $this->db()->insert($mnTable)->value(array('mid'=>$mid,'uid'=>$this->uid(),'type'=>2))->q();
            }
        }
    }
}