<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class IgnoreAction extends BaseAction
{
    public function run()
    {
        $do = empty($_GET['do']) ? 'list' : S::gp('do');
        if (!in_array($do, array('list','add','addall','delete','deleteall')))
        {
            $this->showMessage('非法操作，请返回');
        }
        
        $do = '_'.$do;
        $this->$do();
    }
    
    private function _list()
    {
        $pageSize = 10;
        $ignore = Members::single()->getIgnore($this->uid());
        $result = array();
        if (!empty($ignore))
        {
            if ('{ALL}' == $ignore)
			{
				$result = "当前状态为‘拒绝接收任何人短信’";
			}
			else
			{
			    $pageObj = new iPage();
			    $pageObj->setPageSize($pageSize);
			    $pageObj->setTotalRecord(count($ignore));
			    $sql = 'SELECT uid, username FROM '.Members::table().' WHERE uid IN ('.implode(',',$ignore).') LIMIT '.$pageObj->getOffset().','.$pageObj->getPageSize();
			    $result = $this->db()->setQueryString($sql)->find();
			}
        }
        else
        {
            $result = '当前未没有拒收列表';
        }
        
        $this->getController()->render('ignore',array(
                'result' => $result,
                'pageObj' => $pageObj,
            )
        );
    }
    
    private function _add()
    {
        $uid = S::gp('uid', 'G', 2);
        $check = Members::single()->getNameByUid($uid);
        if (empty($check))
        {
            $this->showMessage('不存在的用户');
        }
        $ignore = Members::single()->getIgnore($this->uid());
        if (empty($ignore))
        {
            $ignore = array();
        }
        else if ('{ALL}' == $ignore)
        {
            $this->showMessage('您当前已经设置禁止接收所有用户短信，不需要再单独添加');
        }
        
        $ignore[] = $uid;
        $this->db()->update(Memberfields::table())->value(array('ignore'=>implode(',',$ignore)))->where('uid='.$this->uid())->q();
        $this->_showMessage();
    }
    
    private function _delete()
    {
        $uid = S::gp('uid', 'G', 2);
        $ignore = Members::single()->getIgnore($this->uid());
        if (empty($ignore))
        {
            $ignore = array();
        }
        else if ('{ALL}' == $ignore)
        {
            $this->showMessage('当前设置为‘拒绝接收任何人短信’，请先设置为’接收所有人短信‘再操作');
        }

        if (in_array($uid,$ignore))
        {
            unset($ignore[array_search($uid,$ignore)]);
        }
        
        $this->db()->update(Memberfields::table())->value(array('ignore'=>implode(',',$ignore)))->where('uid='.$this->uid())->q();
        $this->_showMessage();
    }
    
    private function _deleteall()
    {
        $this->db()->update(Memberfields::table())->value(array('ignore'=>''))->where('uid='.$this->uid())->q();
        $this->_showMessage();
    }
    
    private function _addall()
    {
        $this->db()->update(Memberfields::table())->value(array('ignore'=>'{ALL}'))->where('uid='.$this->uid())->q();
        $this->_showMessage();
    }
    
    public function _showMessage()
    {
        $message[] = '操作成功';
        $message[] = '返回'.ilink('拒收列表',url('system',array('s'=>'member','c'=>'message','a'=>'ignore'))).'.'.ilink('信箱',url('system',array('s'=>'member','c'=>'message'))).'.'.ilink('书房',url('system',array('s'=>'member')));
        $this->showMessage($message);
    }
}