<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class TopAction extends MemberAction
{
    public function run()
    {
        $sort = S::gp('sort','G');
        $navMap = array('wealth'=>'财富榜','level'=>'等级榜','oltime'=>'活跃榜');
        if (!key_exists($sort, $navMap))
        {
            $sort = 'wealth';
        }
        
        $result = call_user_func(array($this, $sort));
        foreach ($result['members'] as &$row)
        {
            if (!empty($row['medals']))
            {
                $row['medals'] = iMedals::single()->getMedalsString($row['medals']);
            }
        }
        $navArray = array();
        foreach ($navMap as $key => $value)
        {
            if ($sort == $key)
            {
                $navArray[] = $value;
            }
            else
            {
                $navArray[] = ilink($value, url('system',array('s'=>'member','c'=>'ranking','a'=>'top','sort'=>$key)));
            }
        }
        $navString = implode('.', $navArray);
        
        $this->getController()->render('top', array(
                'result' => $result,
                'sort' => $sort,
                'navString' => $navString
            )
        );
    }
    
    protected function wealth()
    {
        $iCredit = iCredits::single($this->uid(), $this->userName());
        $moneyField = $iCredit->getMoneyField();
        $sql = "SELECT m.uid,$moneyField AS money,mf.medals FROM ".Members::table().' AS m INNER JOIN '.Memberfields::table().' AS mf ON mf.uid = m.uid WHERE m.uid NOT IN (1,3402,2317) ORDER BY '.$moneyField.' DESC LIMIT 20';
        $members = $this->db()->setQueryString($sql)->find();
        
        return array('title'=>'书友财富榜', 'members' => $members);
    }
    
    protected function level()
    {
        $adminGroupIds = getAdminGroup();
        $sql = 'SELECT groupid FROM '.UserGroups::table().' WHERE gptype = "special"';
        $specialGroups = $this->db()->setQueryString($sql)->find();
        foreach ($specialGroups as $special)
        {
            $adminGroupIds[] = $special['groupid'];
        }
        $groupIds = implode(',', $adminGroupIds);
        $sql = 'SELECT m.uid,groupid,mf.medals FROM '.Members::table().' AS m INNER JOIN '.Memberfields::table().' AS mf ON mf.uid = m.uid WHERE groupid NOT IN ('.$groupIds.') AND m.uid NOT IN (1,3402,2317) ORDER BY groupid DESC LIMIT 20';
        $members = $this->db()->setQueryString($sql)->find();
        
        return array('title'=>'书友等级榜', 'members' => $members);
    }
    
    protected function oltime()
    {
        $sql = 'SELECT m.uid,oltime,mf.medals FROM '.Members::table().' AS m INNER JOIN '.Memberfields::table().' AS mf ON m.uid = mf.uid WHERE m.uid NOT IN (1,3402,2317) ORDER BY oltime DESC LIMIT 20';
        $members = $this->db()->setQueryString($sql)->find();
        
        return array('title'=>'书友活跃榜', 'members' => $members);
    }
}