<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class InfoAction extends MemberAction
{
    public function run()
    {
        $member = $this->getMember($this->uid());
        
        if (isset($_POST['save']))
        {
            $sign = S::gp('sign','P');
            $permissions = Members::single()->getPermissions($this->uid());
            if ($permissions['signlenght'] && mb_strlen(preg_replace('/\s/i','',$sign), 'utf-8') > $permissions['signlenght'])
            {
                throw new iSystemException('您当前所在的用户签名长度不能那个超过'.$permissions['signlenght'].'个字符，请重新修改');
            }

            $book = S::gp('book','P');
            if (30 < mb_strlen($book,'utf-8'))
            {
                throw new iSystemException('最爱小说名长度不能超过30个字');
            }
            
            $memberData = array(
                'size' => intval(S::gp('size','P')),
                'gender' => intval(S::gp('gender','P')),
            );
            $this->db()->update(Members::table())->value($memberData)->where('uid='.$this->uid())->q();
            
            $fieldsData = array(
                'qq' => S::gp('qq','P'),
                'bookshelf' => S::gp('bookshelf','P',2),
                'viewcomment' => S::gp('viewcomment','P',2),
                'sign' => $sign,
                'email' => S::gp('email','P'),
                'bloodtype' => S::gp('bloodtype','P',2),
                'stellation' => S::gp('stellation','P',2),
                'sx' => S::gp('sx','P',2),
                'province' => S::gp('province','P',2),
                'city' => trim(S::gp('city','P')),
                'fstatus' => S::gp('fstatus','P',2),
                'zstatus' => S::gp('zstatus','P',2),
                'book' => $book,
            );
            $birth = S::gp('birth_year','P').'-'.S::gp('birth_month','P').'-'.S::gp('birth_day','P');
            preg_match('/\d{4}-\d{2}-\d{2}/i',$birth) && $fieldsData['birth'] = $birth;

            $this->db()->update(Memberfields::table())->value($fieldsData)->where('uid='.$this->uid())->q();
            Members::single()->updateOneCache($this->uid());
            
            $feed = '{{'.$this->uid().'}}更新了个人资料';
            iFeed::single()->create($feed, $this->uid(), 'member');
            
            $message[] = '资料编辑成功';
            $message[] = '返回'.ilink('书房',url('system',array('s'=>'member'))).'.'.ilink('首页',url('index'));
            $this->showMessage($message);
        }
        $this->getController()->render('info',array(
                'member' => $member,
            )
        );
    }
}