<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ListAction extends MemberAction
{
    public function run()
    {
        $type = S::gp('type', 'G', 2);
        $typeArray = array(0,1,2,3);
        if (!in_array($type, $typeArray))
        {
            throw new iSystemException('非法选项');
        }

        $tag = '';
        $navMap = array(
            1 => '进行中',
            2 => '审核中',
            3 => '已完成',
            0 => '已放弃',
        );
        $navArray = array();
        foreach ($navMap as $key => $value)
        {
            if ($type == $key)
            {
                $tag = $value;
                $navArray[] = $value;
            }
            else
            {
                $navArray[] = ilink($value, url('system', array('s'=>'member','c'=>'task','a'=>'list','type'=>$key)));
            }
        }

        $criteria = new CDbCriteria();
        $criteria->addCondition('t.status='.$type);
        $criteria->addCondition('uid='.$this->uid());
        $tasks = Tasker::model()->with('task')->findAll($criteria);

        $this->getController()->render('list', array(
                'tasks' => $tasks,
                'navArray' => $navArray,
                'tag' => $tag,
            )
        );
    }
}