<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class PayAction extends BaseAction
{
    protected $scale = 500;

    public function run()
    {
        throw new iSystemException('子类必须覆盖此方法');
    }

    public function getSelectList(Yeepay_Validate $validate)
    {
        $allowMoney = $validate->getAllowMoneyList();

        $selectString = array();
        $selectString[] = '<select name="money">';
        foreach ($allowMoney as $money)
        {
            $selectString[] = '<option value="'.$money.'">'.$validate->getName().$money.'元'.($money * $this->getScale()).setting('creditname').'</option>';
        }
        $selectString[] = '</select>';

        return implode('', $selectString);
    }

    public function getCardTips(Yeepay_Validate $validate)
    {
        $tips = $validate->getTips();
        if (array() === $tips)
        {
            return '';
        }

        return implode('<br/>', $tips);
    }

    public function getScale()
    {
        return $this->scale;
    }
}
