<?php
/**
 * 银行类支付回调
 * User: yzxh24
 * Date: 11-9-28
 * Time: 下午4:17
 * To change this template use File | Settings | File Templates.
 */
class BankAction extends PayAction
{
    public function run()
    {
        $config = Yeepay_Config::createFromArray($this->getController()->getPayConfig());
        $yeepay = new Yeepay($config);
        $response = new Yeepay_Response_Buy($yeepay, $_GET);
        try
        {
            $response->verifyHmac();
        }
        catch (Yeepay_Exception $exce)
        {
            exit(0);
        }

        $order = $this->db()->select()->from(YeeOrder::table())->where(array('id'=>$response->order))->find(true);

        // 不存在的支付订单或者已经支付成功的订单之间退出
        if (empty($order) || 0 != $order['status'] || !$order['uid'])
        {
            exit(0);
        }

        if (1 == $response->code)
        {
            // 1表示支付成功
            $realMoney = $response->realMoney;
            $realCredit = $realMoney * $this->getScale();

            $update = array(
                'realmoney' => $realMoney,
                'realcredit' => $realCredit,
                'status' => 1,
                'code' => $response->code,
                'back_type' => $response->backType,
                'bank_id' => S::gp('ro_BankOrderId', 'G'),
                'bank_order_id' => S::gp('rb_BankId', 'G'),
                'trade_id' => $response->tradeId,
                'pay_date' => S::gp('rp_PayDate', 'G'),
                'trade_time' => S::gp('ru_Trxtime', 'G'),
                'ispm' => 1,
            );
            $this->db()->update(YeeOrder::table())->value($update)->where(array('id'=>$order['id']))->q();

            // 增加酷币
            $userName = userName($order['uid']);
            $iCredit = iCredits::single($order['uid'], $userName);
            $iCredit->addMoney($realCredit, false, false);
            $iCredit->log($order['uid'], $userName, $realCredit, 'Pay');

            // 支付成功，站内短信通知
            if (!$order['ispm'])
            {
                $subject = '[系统消息]充值';
                $content = '尊敬的'.userName($order['uid']).'您好，感谢您对'.setting('webname').'的支持，您的充值请求已经处理成功，本次充值您总共获得'.$realCredit.setting('creditname').'。如有疑问，请直接回复本短信。';
                Members::sendMessage($subject, $content, 1, 'admin', $order['uid']);
            }
        }

        // 通知易宝，订单处理完成
        die('success');
    }
}
