<?php
/**
 * 卡类支付回调
 * User: yzxh24
 * Date: 11-9-28
 * Time: 下午4:17
 * To change this template use File | Settings | File Templates.
 */
class CardAction extends PayAction
{
    public function run()
    {
        // 检验回调的合法性
        $config = Yeepay_Config::createFromArray($this->getController()->getPayConfig());
        $yeepay = new Yeepay($config);
        $response = new Yeepay_Response_CallBack($yeepay, $_GET);
        try
        {
            $response->verifyHmac();
        }
        catch (Yeepay_Exception $exce)
        {
            exit(0);
        }
        
        $order = $this->db()->select()->from(YeeOrder::table())->where(array('id'=>$response->order))->find(true);

        // 不存在的支付订单或者已经支付成功的订单之间退出
        if (empty($order) || 0 != $order['status'] || !$order['uid'])
        {
            exit(0);
        }
        
        $code = $response->code; // 支付状态，1成功，非1不成功
        $cardStatus = $response->cardStatus; // 卡状态组
        $realMoney = $response->realAmount; // 实际成功金额
        $balanceAmt = $response->balanceAmt; // 支付余额,此项仅为订单成功,并且需要订单较验时才会有值

        // 充值成功
        if ($code == 1)
        {
            $realCredit = $realMoney * $this->getScale();
            $update = array(
                'realmoney' => $realMoney,
                'realcredit' => $realCredit,
                'trade_time' => CDATETIME,
                'pay_date' => CDATETIME,
                'status' => 1,
                'code' => $code,
                'card_status' => $cardStatus,
                'ispm' => 1,
            );
            $this->db()->update(YeeOrder::table())->value($update)->where(array('id'=>$order['id']))->q();

            // 增加酷币
            $userName = userName($order['uid']);
            $iCredit = iCredits::single($order['uid'], $userName);
            $iCredit->addMoney($realCredit, false, false);
            $iCredit->log($order['uid'], $userName, $realCredit, 'Pay');

            // 支付成功，站内短信通知
            if (!$order['ispm'])
            {
                $subject = '[系统消息]充值';
                $content = '尊敬的'.userName($order['uid']).'您好，感谢您对'.setting('webname').'的支持，您的充值请求已经处理成功，本次充值您总共获得'.$realCredit.setting('creditname').'。如有疑问，请直接回复本短信。';
                Members::sendMessage($subject, $content, 1, 'admin', $order['uid']);
            }
        }
        else
        {
            // 充值失败
            $update = array(
                'trade_time' => CDATETIME,
                'status' => 3, // 失败
                'code' => $code,
                'card_status' => $cardStatus,
                'ispm' => 1
            );
            $this->db()->update(YeeOrder::table())->value($update)->where(array('id'=>$order['id']))->q();

            if (!$order['ispm'])
            {
                $subject = '[系统消息]充值';
                $content = '尊敬的'.userName($order['uid']).'您好，感谢您对'.setting('webname')."的支持，您的充值未能处理成功，失败原因：【".YeeOrder::$cardStatusMap[$cardStatus]."】\n\n如有疑问，请回复本短信咨询";
                Members::sendMessage($subject, $content, 1, 'admin', $order['uid']);
            }
        }

        // 通知易宝，订单处理完成
        die('success');
    }
}