<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class WapAction extends PayAction
{
    public function run()
    {
        $this->getController()->isLogin();
        $pd = strtoupper(S::gp('pd', 'G'));
        $allowPdMap = array('ICBC' => '工商银行', 'CMBCHINA' => '招商银行', 'CCB' => '建设银行');
        if (!key_exists($pd, $allowPdMap))
        {
            throw new iSystemException('不支持的支付通道，请返回重新选择');
        }

        $bankName = $allowPdMap[$pd];
        $allowMoneyMap = array(1, 10, 20, 30, 50, 100, 200, 300);
        $scale = $this->getScale();

        if ($_POST['money'])
        {
            $money = S::gp('money', 'P', 2);
            if (!in_array($money, $allowMoneyMap))
            {
                throw new iSystemException('不支持的充值额度，当前只支持'.implode('、', $allowMoneyMap.'元的充值'));
            }

            $pdName = $pd . '-WAP';
            $credit = $money * $this->getScale();
            // 生成一个内部订单
            $orderData = array(
                'uid' => $this->uid(),
                'status' => 0,
                'money' => $money,
                'product_id' => $pdName,
                'merchant_persist' => $pdName,
                'credit' => $credit,
                'createdate' => CDATETIME,
            );
            $this->db()->insert(YeeOrder::table())->value($orderData)->q();
            $orderId = $this->db()->getInsertId();
            if (!$orderId)
            {
                throw new iSystemException('充值失败，可能是系统较忙，请过两分钟再试');
            }
            
            $config = Yeepay_Config::createFromArray($this->getController()->getPayConfig());
            $yeepay = new Yeepay($config);
            $request = $yeepay->makeOrder('Buy');
            /**/
            $request->order = $orderId;
            //$request->amount = $orderData['money'];
            $request->amount = $money; // 调试，不能大于1元
            $request->productId = $orderData['product_id'];
            $request->productCategory = '2';
            $request->productDescription = $pdName.'_'.$money;
            //$request->callbackUrl = 'http://25800.net/yee.php?id='.$orderId; // 调试用
            $request->callbackUrl = $yeepay->getRequestUrl('BankBackUrl');
            $request->merchantPersist = '25800';
            $request->cardAmt = $money;
            $request->frpId = $pdName;
            $request->saf = '0';
            $request->needResponse = '1';
            /**/
            /**
            $request->order = 1;
            $request->amount = 1;
            $request->productId = '1';
            $request->productCategory = '1';
            $request->productDescription = '1';
            $request->callbackUrl = 'http://localhost/HTMLcommon/callback.php';// 调试用
            $request->merchantPersist = 'userId';
            $request->cardAmt = $money;
            $request->frpId = $pd.'-WAP';
            $request->saf = '0';
            $request->needResponse = '1';
            /**/
            $this->getController()->render('_go', array('request'=>$request));
            exit(0);
        }
        
        $this->getController()->render('wap', array(
                'bankName' => $bankName,
                'pd' => $pd,
                'scale' => $scale,
                'allowMoneyMap' => $allowMoneyMap,
            )
        );
    }
}
