<?php
/**
 * 卡类充值
 * User: yzxh24
 * Date: 11-9-26
 * Time: 下午6:53
 * To change this template use File | Settings | File Templates.
 */
class MobileAction extends PayAction
{
    public function run()
    {
        $this->getController()->isLogin();
        $pd = strtoupper(S::gp('pd', 'G'));
        
        $allowPdMap = array('SZX', 'TELECOM', 'UNICOM', 'QQCARD', 'NETEASE', 'SNDACARD', 'ZHENGTU', 'WANMEI');
        if (!in_array($pd, $allowPdMap))
        {
            throw new iSystemException('不支持的支付通道，请返回重新选择');
        }
        $validClass = 'Yeepay_Validate_'.$pd;
        $validate = new $validClass;

        if ($_POST['cardNum'])
        {
            $cardNum = trim(S::gp('cardNum', 'P'));
            $cardPass = trim(S::gp('cardPass', 'P'));
            $money = S::gp('money', 'P', 2);

            $validate->setCardNum($cardNum);
            $validate->setCardPass($cardPass);
            
            // 验证卡的情况
            try
            {
                $validate->validate($money);
            }
            catch (Yeepay_Validate_Exception $exce)
            {
                throw new iSystemException($exce->getMessage());
            }

            $credit = $money * $this->getScale();
            // 生成一个内部订单
            $orderData = array(
                'uid' => $this->uid(),
                'status' => 0,
                'card_no' => $cardNum,
                'card_pass' => $cardPass,
                'money' => $money,
                'product_id' => $pd,
                'merchant_persist' => $pd.'_'.$money,
                'credit' => $credit,
                'createdate' => CDATETIME,
            );
            $this->db()->insert(YeeOrder::table())->value($orderData)->q();
            $orderId = $this->db()->getInsertId();
            if (!$orderId)
            {
                throw new iSystemException('充值失败，可能是系统较忙，请过两分钟再试');
            }

            // 实例化易宝支付对象
            $config = Yeepay_Config::createFromArray($this->getController()->getPayConfig());
            $yeepay = new Yeepay($config);
            $request = $yeepay->makeOrder();
            $request->order = $orderId;
            $request->amount = $orderData['money'];
            $request->verifyAmt = 'false';
            $request->productId = $orderData['product_id'];
            $request->productCategory = 1;
            $request->productDescription = $pd.'_'.$money;
            $request->callbackUrl = $yeepay->getRequestUrl('CardBackUrl');
            //$request->callbackUrl = 'http://25800.net/yee.php?id='.$orderId; // 调试用
            $request->merchantPersist = $orderData['merchant_persist'];
            $request->cardAmt = $money;
            $request->cardNo = $orderData['card_no'];
            $request->cardPwd = $orderData['card_pass'];
            $request->frpId = $pd;
            $request->needResponse = 1;
            $request->userId = $this->uid();
            $request->userRegTime = $orderData['createdate'];
            $response = $request->getResponse();

            // 验证支付情况
            try
            {
                $response->verify();
            }
            catch (Yeepay_Exception $exce)
            {
                throw new iSystemException($exce->getMessage());
            }

            //$message[] = '恭喜，系统已经接收到了您的充值请求，目前正在处理，这可能需要1-2分钟的时间，请耐心等待一下^_^';
            //$message[] = ilink('&lt;&lt;点击我查看充值是否已经完成&gt;&gt;', url('system', array('s'=>'pay','a'=>'query','id'=>$orderId)));
            //$this->showMessage($message);
            iforward(url('system', array('s'=>'pay','a'=>'query','id'=>$orderId)));
        }

        $selectList = $this->getSelectList($validate);
        $tips = $this->getCardTips($validate);

        $this->getController()->render('mobile', array(
                'validate' => $validate,
                'pd'=>$pd,
                'selectList' => $selectList,
                'tips' => $tips,
            )
        );
    }
}