<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class PropsController extends BaseController
{
    public $propertyMemberTable = 'ig_property_member';
    
    public $propertyLogTable = 'ig_property_log';

    public $medalListMap = array(
        5 => '暗之幽冥系列',
        6 => '美女帅哥系列',
        7 => '个性系列',
        8 => '紫色梦幻系列',
        9 => '十二星座系列',
        10 => '七彩炫酷系列',
    );

    public $typeList = array(
        1 => '小说',
        2 => '书会',
        3 => '勋章',
        4 => '功能',
    );

    public function getProp($name)
    {
        $property = $this->db()->select()->from(Property::table())->where(array('status'=>1,'module'=>$name))->find(true);
        if (empty($property))
        {
            throw new iSystemException('不存在的道具');
        }
        
        return $property;
    }

    public function isLogin()
    {
        isLogin();
    }

    public function isVerify()
    {
        global $_IORANGE;

        if (!$_IORANGE['user']['verify'])
        {
            throw new iSystemException('此道具只对验证会员出售');
        }

        return true;
    }

    public function hasMoney($uid, $username, $money)
    {
        $field = iCredits::single($uid, $username)->getMoneyField();
        $credit = $this->db()->getValue('SELECT '.$field.' FROM '.Members::table().' WHERE uid='.$uid);
        if ($money > $credit)
        {
            throw new iSystemException(setting('creditname').'不够，不能购买');
        }

        return true;
    }

    public function hasPropMemberLog($uid, $propertyName)
    {
        try
        {
            $property = $this->getProp($propertyName);
        }
        catch (iSystemException $e)
        {
            $this->showMessage($e->getMessage());
        }
        
        $result = $this->db()->select()->from($this->propertyMemberTable)->where(array('uid'=>$uid,'property_id'=>$property['propertyid']))->find(true);

        return empty($result) ? false : $result;
    }

    public function hasMedal($uid, $medalName, $medalId)
    {
        $check = $this->db()->select(array('medals'))->from(Memberfields::table())->where(array('uid'=>$uid))->find(true);
        if (!empty($check['medals']))
        {
            $existsMedals = iMedals::single()->getMedalsString($check['medals']);
            if (!empty($existsMedals))
            {
                $message[] = '您当前已经有'.count($existsMedals['images']).'枚勋章:'.implode('', $existsMedals['images']);
                $message[] = '如果购买新的，之前的将被删除，是否'.ilink('购买',url('system',array('s'=>'props','c'=>$medalName,'a'=>'buy','do'=>1,'id'=>$medalId))).'？';
                $this->showMessage($message);
            }
        }
        
        return true;
    }

    public function getMedal($string, $pageSize = 5)
    {
        $countSql = 'SELECT COUNT(*) AS c FROM '.Medals::table()." WHERE `type`='{$string}'";
        $count = $this->db()->getValue($countSql);

        $pagination = new iPage();
        $pagination->setPageSize($pageSize);
        $pagination->setTotalRecord($count);

        $sql = 'SELECT * FROM '.Medals::table()." WHERE `type`='{$string}' LIMIT ".$pagination->getOffset().','.$pagination->getPageSize();
        $medals = $this->db()->setQueryString($sql)->find();

        return array('pagination'=>$pagination,'medals'=>$medals);
    }

    public function createPropMemberLog($uid, $userName, $propertyId, $option)
    {
        $this->db()->insert($this->propertyMemberTable)->value(array('uid'=>$uid,'username'=>$userName,'property_id'=>$propertyId,'option'=>$option))->q();
    }

    public function updatePropMemberLog($uid, $userName, $propertyId, $option)
    {
        $this->db()->update($this->propertyMemberTable)->value(array('option'=>$option))->where(array('uid'=>$uid,'property_id'=>$propertyId))->q();
    }

    public function indexLink($tag = '进入查看更多道具&gt;&gt;')
    {
        return ilink($tag, url('system',array('s'=>'props')));
    }

    public function getNavLink($type)
    {
        $types = array(0=>'全部') + $this->typeList;
        foreach ($types as $key => $value)
        {
            if ($key === $type)
            {
                $return[] = $value;
            }
            else
            {
                $return[] = ilink($value, url('system',array('s'=>'props','t'=>$key)));
            }
        }
        return implode('.', $return);
    }
}