<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class WaController extends PropsController
{
    public $actionMap = array(
        'index' => 'IndexAction',
        'use' => 'UseAction',
        'medal' => 'MedalAction',
        'comment' => 'CommentAction',
    );

    public $priceMap = array(
        1 => 2,
        2 => 10,
        3 => 50,
    );

    public $propMap = array(
        1 => array(1 => 10, 2 => 10, 3 => 5, 4 => 5, 0 => 3, -1 => 77,),
        2 => array(13 => 4, 12 => 4, 0 => 2, -1 => 90,),
        3 => array(5 => 2, 13 => 4, 12 => 3, 0 => 1, -1 => 90,),
    );

    public function proRand($pro, $num = 1)
    {
        if ($num > count($pro))
        {
            exit("{$num} is too long and exit !");
        }
        $max_exp = 0;
        foreach ($pro as $key => $value)
        {
            $exp = strlen(strchr($value, '.')) - 1;
            if ($exp > $max_exp)
            {
                $max_exp = $exp;
            }
        }
        $pow_exp = pow(10, $max_exp);
        if ($pow_exp > 1)
        {
            reset($pro);
            foreach ($pro as $key => $value)
            {
                $pro[$key] = $value * $pow_exp;
            }
        }
        $pro_sum = array_sum($pro);
        for ($i = 0; $i < $num; $i ++)
        {
            $rand_num = mt_rand(1, $pro_sum);
            reset($pro);
            foreach ($pro as $key => $value)
            {
                if ($rand_num <= $value)
                {
                    break;
                }
                else
                {
                    $rand_num -= $value;
                }
            }
            $res[$i] = array($key , $value * 1.0 / $pow_exp);
            $pro_sum -= $value;
            unset($pro[$key]);
        }
        
        return $res;
    }
}