<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class DenyAction extends BaseAction
{
    public function run()
    {
        if (!u('superbm') && !isGM($this->uid()))
        {
            $this->showMessage('没有权限');
        }

        $uid = S::gp('uid', 'G', 2);
        try
        {
            $user = Members::single()->getOne($uid);
        }
        catch (MemberNotExistsException $exce)
        {
            $this->showMessage($exce->getMessage());
        }

        if (isset($_POST['expiry']))
        {
            if (isGM($uid))
            {
                $this->showMessage('您无权禁止此用户');
            }

            $expiry = S::gp('expiry','P', 2);
            if (!isGM($this->uid()) && !$expiry)
            {
                throw new iSystemException('您无权永久禁止');
            }
            $remark = trim(S::gp('remark', 'P'));
            if (empty($remark))
            {
                throw new iSystemException('请输入禁止原因');
            }

            if (mb_strlen($remark,'utf-8') < 5)
            {
                throw new iSystemException('请输入详细的禁止原因');
            }

            $expiry = $expiry ? CTIME + ($expiry * 24 * 3600) : 0;
            $this->db()->insert(DenyBugle::table())->value(array('uid'=>$uid, 'operate_uid'=>$this->uid(), 'remark'=>$remark, 'createdate'=>CDATETIME, 'expiry'=>$expiry))->q();

            $this->showMessage('禁止使用喇叭成功');
        }

        $this->getController()->render('deny', array('uid'=>$uid));
    }
}