<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class UseAction extends BaseAction
{
    public function run()
    {
        $this->getController()->isLogin();
        $uid = S::gp('uid', 'P', 2);
        if (!$uid)
        {
            throw new iSystemException('请输入要清除猪头效果的用户UID');
        }

        $property = $this->getController()->getProp('cpig');
        $price = $property['price'];

        try
        {
            Members::single()->hasMoney($this->uid(), $price);
            $member = Members::single()->getOne($uid);
        }
        catch (NotEnoughMoneyException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }
        catch (MemberNotExistsException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }

        iCredits::single($this->uid(), $this->userName())->consume($price);

        if (false === ($prop = $this->getController()->hasPropMemberLog($this->uid(), 'cpig')))
        {
            $this->getController()->createPropMemberLog($this->uid(),$this->userName(), $property['propertyid'], serialize(array('class'=>1)));
        }

        $data = array(
            'uid' => $this->uid(),
            'username' => $this->userName(),
            'amount' => 1,
            'price' => $price,
        );
        PropertyLog::single()->create($property['propertyid'],$data);

        $this->cache()->remove('PIG_'.$uid);
        $message[] = '恭喜你，猪头清除成功，赶紧去'.ilink('看看', url('system', array('s'=>'member','uid'=>$uid))).'吧';
        $this->showMessage($message);
    }
}