<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class UseAction extends BaseAction
{
    public function run()
    {
        $this->getController()->isLogin();
        if (!isset($_POST['uid']))
        {
            throw new iSystemException('非法操作');
        }

        $uid = S::gp('uid', 'P', 2);
        $property = $this->getController()->getProp('find');
        $price = $property['price'];
        if ($uid == $this->uid())
        {
            throw new iSystemException('你是在搞笑吗？');
        }

        try
        {
            Members::single()->hasMoney($this->uid(), $price);
            $member = Members::single()->getOne($uid);
        }
        catch (NotEnoughMoneyException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }
        catch (MemberNotExistsException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }

        if (!isOnline($uid))
        {
            throw new iSystemException('对方不在线，无法追踪');
        }
        iCredits::single($this->uid(), $this->userName())->consume($price);

        if (false === ($prop = $this->getController()->hasPropMemberLog($this->uid(), 'find')))
        {
            $this->getController()->createPropMemberLog($this->uid(),$this->userName(), $property['propertyid'], serialize(array('class'=>1)));
        }

        $data = array(
            'uid' => $this->uid(),
            'username' => $this->userName(),
            'amount' => 1,
            'price' => $price,
        );
        PropertyLog::single()->create($property['propertyid'],$data);

        $lastActivityUrl = Members::single()->getLastActivityUrl($uid);
        if (!rand(0, 1) || !$lastActivityUrl)
        {
            throw new iSystemException('-__-抱歉，追踪失败，你可以返回重试'.backLink());
        }

        $lastActivityUrl = str_replace('&', '&amp;', cleanSid($lastActivityUrl));
        $goUrl = $lastActivityUrl . (preg_match('/\?/i', $lastActivityUrl) ? '&amp;' : '?') . 'sid='.$this->sid();
        $message[] = '事实证明，我是最优秀的狗仔队成员！已帮你找到此人下落，点击下面链接速去围观！';
        $message[] = ilink('&lt;&lt;对Ta进行惨无人道的围观&gt;&gt;', $goUrl);
        $this->showMessage($message);
    }
}
