<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BuyAction extends BaseAction
{
    public function run()
    {
        if (!empty($_POST['num']))
        {
            $this->getController()->isLogin();

            $num = S::gp('num', 'G', 2);
            if ($num < 1)
            {
                throw new iSystemException('购买的数量必须大于0');
            }

            $property = $this->getController()->getProp('flower');
            if ($property['nums'] < 1)
            {
                throw new iSystemException('今天的鲜花已经卖完，请明天赶早^_^');
            }
            if ($property['higher'] < $num)
            {
                throw new iSystemException('一次最多只能购买' . $property['higher'] . '朵鲜花');
            }
            if ($property['nums'] < $num)
            {
                throw new iSystemException('所剩鲜花不足'.$num.'朵');
            }
            
            $money = $property['price'] * $num;
            $this->getController()->hasMoney($this->uid(),$this->userName(),$money);
            iCredits::single($this->uid(), $this->userName())->consume($money);
            
            if (false !== ($prop = $this->getController()->hasPropMemberLog($this->uid(), 'flower')))
            {
                $option = unserialize($prop['option']);
                $option['amount'] += $num;
                $this->getController()->updatePropMemberLog($this->uid(), $this->userName(), $property['propertyid'], serialize($option));
            }
            else
            {
                $this->getController()->createPropMemberLog($this->uid(),$this->userName(), $property['propertyid'], serialize(array('class'=>1,'amount'=>$num)));
            }
            $this->db()->query('UPDATE `'.Property::table()."` SET `nums` = `nums` - $num WHERE `module` = 'flower'");

            $data = array(
                'uid' => $this->uid(),
                'username' => $this->userName(),
                'amount' => $num,
                'price' => $money,
            );
            PropertyLog::single()->create($property['propertyid'],$data);

            $message[] = '购买成功，您现在可以给喜欢的小说送花了';
            $message[] = '返回'.ilink('继续购买', url('system',array('s'=>'props','c'=>'flower'))).'.'.indexLink().'.'.memberLink();
            $this->showMessage($message);
        }
        else
        {
            throw new iSystemException('非法操作');
        }
    }
}