<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class UseAction extends BaseAction
{
    public function run()
    {
        $this->getController()->isLogin();
        $bookid = S::gp('id', 'G', 2);

        $book = fetchBookForum($bookid);
        if (empty($book))
        {
            throw new iSystemException('不存在的书会');
        }
        
        if (false === ($prop = $this->getController()->hasPropMemberLog($this->uid(), 'frecommend')))
        {
            throw new iSystemException('您还没有狂顶书会票，是否需要' . ilink('购买', url('system',array('s'=>'props','c'=>'frecommend'))) . '？');
        }
        $option = unserialize($prop['option']);
        if (1 > $option['amount'])
        {
            throw new iSystemException('您的狂顶书会票已经用完，是否需要' . ilink('购买', url('system',array('s'=>'props','c'=>'frecommend'))) . '？');
        }
        $option['amount'] = $num = $option['amount'] - 1;
        $this->getController()->updatePropMemberLog($this->uid(), $this->userName(), $prop['property_id'], serialize($option));
        $this->db()->update(BookForum::table())->incrField(array('commends'=>1))->where('bookid='.S::sqlEscape($bookid))->q();

        $data = array(
            'bookid' => $bookid,
            'forumname' => $book['forumname'],
            'uid' => $this->uid(),
            'username' => ubb($this->userName())
        );
        setForumRecommend($data);
        Dynamic::single()->createForumDynamic($bookid, 3);

        $message[] = '使用成功<br/>返回'.forumLink($bookid).'.'.bookLink($bookid).'.'.memberLink();
        $this->showMessage($message);
    }
}