<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BuyAction extends BaseAction
{
    public function run()
    {
        $property = $this->getController()->getProp('rename');
        
        if (isset($_POST['name']))
        {
            $this->getController()->isLogin();
            $newName = S::gp('name','P');
            if (!$newName)
            {
                throw new iSystemException('请输入要改的名字');
            }
            $rObj = Rename::single();
            if (!$rObj->isRename($this->uid()))
            {
                throw new iSystemException('每周仅允许修改一次昵称，请下周再来');
            }
            $money = $property['price'];
            $this->getController()->hasMoney($this->uid(),$this->userName(),$money);
            if (!$rObj->check($this->uid(), $newName))
            {
                throw new iSystemException('名字'.$newName.'已经有人使用，请换一个');
            }
            try
            {
                Members::validateUserName($newName);
            }
            catch (UserNameValidateException $exce)
            {
                throw new iSystemException($exce->getMessage());
            }
            iCredits::single($this->uid(), $this->userName())->consume($money);
            Members::single()->rename($this->uid(), $newName, $this->userName());
            
            if (false === ($prop = $this->getController()->hasPropMemberLog($this->uid(), 'rename')))
            {
                $this->getController()->createPropMemberLog($this->uid(),$this->userName(), $property['propertyid'], serialize(array('class'=>3)));
            }
            
            $data = array(
                'uid' => $this->uid(),
                'username' => $this->userName(),
                'amount' => 1,
                'price' => $money,
            );
            PropertyLog::single()->create($property['propertyid'],$data);
            $message[] = '恭喜，您的用户名修改成功！';
            $message[] = '返回'.memberLink().'.'.indexLink();
            $this->showMessage($message);
        }
        
        $this->getController()->render('buy', array('property' => $property));
    }
}