<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CommentAction extends SoftAction
{
    public function run()
    {
        $this->getController()->isLogin();
        
        $id = S::gp('id', 'G', 2);
        $back = S::gp('back', 'G');
        $content = sFilter($this->getController()->filter(S::gp('content', 'P')));
        $soft = $this->db()->select(array('id','name','floor'))->from(SoftContents::table())->where(array('id'=>$id))->find(true);
        if (empty($soft))
        {
            throw new iSystemException('不存在的软件，不能评论');
        }
        if (empty($content) || 3 > mb_strlen($content, 'utf-8'))
        {
            throw new iSystemException('评论内容不能少于3个字');
        }

        $comment = array(
            'cid' => $id,
            'uid' => $this->uid(),
            'content' => $content,
            'floor' => $soft['floor'] + 1,
            'createdate' => CDATETIME,
        );
        $this->db()->insert(SoftComments::table())->value($comment)->q();
        $this->db()->update(SoftContents::table())->incrField(array('comments' => 1, 'floor' => 1))->where(array('id'=>$id))->q();
        
        if (empty($back))
        {
            $back = url('system', array('s'=>'soft','a'=>'view','id'=>$id));
        }

        iforward($back);
    }
}