<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class DownloadAction extends SoftAction
{
    public function run()
    {
        $fid = S::gp('fid', 'G', 2);
        $softFile = $this->db()->select()->from(SoftPcontents::table())->where('id='.$fid)->find(true);

        $file = SoftPcontents::getSavePath() . $softFile['date'] . DS . $softFile['filename'];
        if (!is_file($file))
        {
            throw new iSystemException('下载的附件不存在');
        }
        $soft = SoftContent::model()->findByPk($softFile['cid'], array('select'=>'award'));

        $this->db()->update(SoftContents::table())->incrField(array('day_download'=>1,'week_download'=>1,'month_download'=>1,'download'=>1))->where(array('id'=>$softFile['cid']))->q();
        $this->db()->update(SoftPcontents::table())->incrField(array('day_download'=>1,'week_download'=>1,'month_download'=>1,'download'=>1))->where(array('id'=>$softFile['id']))->q();

        if ($this->uid() && $soft->isAward())
        {
            $count = SoftDownload::model()->count(array('condition'=>'uid='.$this->uid().' AND fid='.$fid));
            if (!$count)
            {
                iCredits::single($this->uid(), $this->userName())->addMoney($soft->award);
            }
        }

        $down = new SoftDownload();
        $down->cid = $softFile['cid'];
        $down->fid = $fid;
        $down->uid = $this->uid();
        $down->ua = S::getServer('HTTP_USER_AGENT');
        $down->save();
        //print_r($down);die;
        
        $iDownload = new iDownload($file, $softFile['name']);
        $iDownload->send();
    }
}