<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ViewAction extends SoftAction
{
    public function run()
    {
        $id = S::gp('id', 'G', 2);
        $full = S::gp('f', 'G', 2);

        $soft = SoftContent::model()->findByPk($id);
        if (empty($soft))
        {
            throw new iSystemException('不存在的软件');
        }
        $fileList = $this->db()->select()->from(SoftPcontents::table())->where('cid='.$id.' AND isdelete = 0')->find();
        
        if (preg_match('/\[fenye\]/is', $soft->info, $match))
        {
            if (!$full)
            {
                $infoArray = explode('[fenye]', $soft->info);
                $count = count($infoArray);
                $pageObj = new iPage();
                $pageObj->setTotalRecord($count);
                $pageObj->setPageSize(1);

                $soft->info = $infoArray[$pageObj->getCurrentPage() - 1];
            }
        }
        $soft->info = preg_replace('/\[fenye\]/is', '', $soft->info);

        if (isset($pageObj) && 1 == $pageObj->getCurrentPage() || !isset($pageObj))
        {
            $appendArray = array();
            if ($soft->isAward())
            {
                $appendArray[] = '<b>*下载安装即奖励'.$soft->award.setting('creditname').'*</b>';
            }
            $appendArray[] = '<b>平台</b>: '.implode(' ', $this->getPlatform($fileList));
            $appendArray[] = '<b>名称</b>: '.$soft->name;

            if (!empty($soft->version))
            {
                $appendArray[] = '<b>版本</b>: '. $soft->version;
            }
            $appendArray[] = '<b>更新</b>: '.date('Y-m-d', strtotime($soft->createdate));
            $appendArray[] = '<b>介绍</b>: ';
            $soft->info = implode('<br/>', $appendArray) . '<br/>'. $soft->info;
        }
        $fileList = $this->analyzeFileList($fileList);

        $sql = 'SELECT uid,content,createdate FROM '.SoftComments::table().' WHERE cid='.$id.' ORDER BY id DESC LIMIT 5';
        $comments = $this->db()->setQueryString($sql)->find();

        $sql = 'SELECT id,name FROM '.SoftContents::table().' WHERE id <> '.$id.' AND cid='.$soft->cid.' ORDER BY rand() LIMIT 5';
        $commends = $this->db()->setQueryString($sql)->find();

        $this->getController()->render('view', array(
                'soft' => $soft,
                'fileList' => $fileList,
                'comments' => $comments,
                'pageObj' => $pageObj,
                'commends' => $commends,
            )
        );
    }

    private function getPlatform($fileList)
    {
        $platforms = SoftPlatforms::getList();
        $pArray = array();
        foreach ($fileList as $file)
        {
            $pArray[$file['pid']] = ilink($platforms[$file['pid']], url('system', array('s'=>'soft','a'=>'platform','id'=>$file['pid'])));
        }

        return $pArray;
    }

    /**
     * 整理软件列表，输出一个类似下面的列表
     * =塞班平台=
     * xxx.sis()
     * =Android平台=
     * xxx.apk
     * @param  $fileList
     * @return array
     */
    private function analyzeFileList($fileList)
    {
        $platforms = SoftPlatforms::getList();
        $pArray = array();
        foreach ($fileList as $file)
        {
            $pArray[$platforms[$file['pid']]][] = $file;
        }

        return $pArray;
    }
}