<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1" />
<link href="<?php echo getJsFile('jquery/mobile/jquery.mobile-1.0rc1.min.css');?>" rel="stylesheet" type="text/css" />
<script src="<?php echo getJsFile('jquery/mobile/jquery.min.js');?>"></script>
<script src="<?php echo getJsFile('jquery/mobile/jquery.mobile-1.0rc1.min.js');?>"></script>
<title><?php echo $bookname;?> - 章节目录列表</title>
</head>
<body>

<div data-role="header" data-position="inline">
    <a data-rel="back" data-icon="back" data-direction="reverse" class="ui-btn-left">返回</a>
    <h1><?php echo $bookname;?></h1>
</div>


<ul data-role="listview">
<?php if (!empty($chapters)):?>
    <?php foreach($chapters as $chapter):?>
        <li>
            <a class="ui-link-inherit" href="<?php echo url('read', array('bid'=>$chapter['bookid'],'cid'=>$chapter['chapterid']));?>"><?php echo $chapter['chaptername'];?></a>
        </li>
    <?php endforeach;?>

    <div>
    <?php if ($pageObj->hasPrev()):?>
            <a data-ajax="false" data-role="button" data-inline="true" data-icon="arrow-l" data-iconpos="left" href="<?php echo $pageObj->getUrl('page', $pageObj->getCurrentPage() - 1);?>">上一页</a>
        <?php endif;?>
        <?php if ($pageObj->hasNext()):?>
            <a data-ajax="false" data-role="button" data-inline="true" data-icon="arrow-r" data-iconpos="right" href="<?php echo $pageObj->getUrl('page', $pageObj->getCurrentPage() + 1);?>">下一页</a>
        <?php endif;?>
        <br/>
        共<?php echo $pageObj->getTotalRecord();?>章[<?php echo $pageObj->getCurrentPage();?>/<?php echo $pageObj->getTotalPage();?>页]
    </div>
<?php else:?>
    暂无章节
<?php endif;?>
</ul>
<div data-role="footer" data-id="foo1" data-position="fixed">
    <div data-role="navbar">
		<ul>
            <li><a href="<?php echo url('bookshow', array('bid'=>$bookid));?>">书页</a></li>
            <li><a href="<?php echo url('system', array('s'=>'member'));?>">书房</a></li>
            <li><a href="<?php echo url('index');?>">首页</a></li>
        </ul>
    </div>
</div>
</body>
</html>