<?php   if(!defined('DEDEINC')) exit('dedecms');
/**
 * ޲z޿
 *
 * @version        $Id: file_class.php 1 19:09 2010~712Z tianya $
 * @package        DedeCMS.Administrator
 * @copyright      Copyright (c) 2007 - 2010, DesDev, Inc.
 * @license        http://help.dedecms.com/usersguide/license.html
 * @link           http://www.dedecms.com
 */
class FileManagement
{
    var $baseDir="";
    var $activeDir="";

    //O_\޲zRؿF
    //q{\ 0 ,pGƱi޲zӥؿ,Чȳ] 1 F
    var $allowDeleteDir=0;

    //lƨt
    function Init()
    {
        global $cfg_basedir, $activepath;
        $this->baseDir = $cfg_basedir;
        $this->activeDir = $activepath;
    }

    //W
    function RenameFile($oldname,$newname)
    {
        $oldname = $this->baseDir.$this->activeDir."/".$oldname;
        $newname = $this->baseDir.$this->activeDir."/".$newname;
        if(($newname!=$oldname) && is_writable($oldname))
        {
            rename($oldname,$newname);
        }
        ShowMsg("\@ӤWI","file_manage_main.php?activepath=".$this->activeDir);
        return 0;
    }

    //Ыطsؿ
    function NewDir($dirname)
    {
        $newdir = $dirname;
        $dirname = $this->baseDir.$this->activeDir."/".$dirname;
        if(is_writable($this->baseDir.$this->activeDir))
        {
            MkdirAll($dirname,$GLOBALS['cfg_dir_purview']);
            CloseFtp();
            ShowMsg("\Ыؤ@ӷsؿI","file_manage_main.php?activepath=".$this->activeDir."/".$newdir);
            return 1;
        }
        else
        {
            ShowMsg("ЫطsؿѡA]oӦm\gJI","file_manage_main.php?activepath=".$this->activeDir);
            return 0;
        }
    }

    /**
     *  ʤ
     *
     * @access    public
     * @param     string  $mfile  
     * @param     string  $mpath  |
     * @return    string
     */
    function MoveFile($mfile, $mpath)
    {
        if($mpath!="" && !preg_match("#\.\.#", $mpath))
        {
            $oldfile = $this->baseDir.$this->activeDir."/$mfile";
            $mpath = str_replace("\\","/",$mpath);
            $mpath = preg_replace("#\/{1,}#", "/", $mpath);
            if(!preg_match("#^/#", $mpath))
            {
                $mpath = $this->activeDir."/".$mpath;
            }
            $truepath = $this->baseDir.$mpath;
            if(is_readable($oldfile) && is_readable($truepath) && is_writable($truepath))
            {
                if(is_dir($truepath))
                {
                    copy($oldfile, $truepath."/$mfile");
                }
                else
                {
                    MkdirAll($truepath, $GLOBALS['cfg_dir_purview']);
                    CloseFtp();
                    copy($oldfile,$truepath."/$mfile");
                }
                unlink($oldfile);
                ShowMsg("\ʤI","file_manage_main.php?activepath=$mpath",0,1000);
                return 1;
            }
            else
            {
                ShowMsg("ʤ $oldfile -&gt; $truepath/$mfile ѡAiOYӦmvI","file_manage_main.php?activepath=$mpath",0,1000);
                return 0;
            }
        }
        else
        {
            ShowMsg("藍_AAʪ|XkI","-1",0,5000);
            return 0;
        }
    }

    /**
     * Rؿ
     *
     * @param unknown_type $indir
     */
    function RmDirFiles($indir)
    {
        if(!is_dir($indir))
        {
            return ;
        }
        $dh = dir($indir);
        while($filename = $dh->read())
        {
            if($filename == "." || $filename == "..")
            {
                continue;
            }
            else if(is_file("$indir/$filename"))
            {
                @unlink("$indir/$filename");
            }
            else
            {
                $this->RmDirFiles("$indir/$filename");
            }
        }
        $dh->close();
        @rmdir($indir);
    }

    /**
     * oYؿXųWh
     *
     * @param unknown_type $indir
     * @param unknown_type $fileexp
     * @param unknown_type $filearr
     */
    function GetMatchFiles($indir, $fileexp, &$filearr)
    {
        $dh = dir($indir);
        while($filename = $dh->read())
        {
            $truefile = $indir.'/'.$filename;
            if($filename == "." || $filename == "..")
            {
                continue;
            }
            else if(is_dir($truefile))
            {
                $this->GetMatchFiles($truefile, $fileexp, $filearr);
            }
            else if(preg_match("/\.(".$fileexp.")/i",$filename))
            {
                $filearr[] = $truefile;
            }
        }
        $dh->close();
    }

    /**
     * R
     *
     * @param unknown_type $filename
     * @return unknown
     */
    function DeleteFile($filename)
    {
        $filename = $this->baseDir.$this->activeDir."/$filename";
        if(is_file($filename))
        {
            @unlink($filename); $t="";
        }
        else
        {
            $t = "ؿ";
            if($this->allowDeleteDir==1)
            {
                $this->RmDirFiles($filename);
            }
        }
        ShowMsg("\R@".$t."I","file_manage_main.php?activepath=".$this->activeDir);
        return 0;
    }
}

//ؿjp˴
class SpaceUse
{
    var $totalsize=0;

    function checksize($indir)
    {
        $dh=dir($indir);
        while($filename=$dh->read())
        {
            if(!preg_match("#^\.#", $filename))
            {
                if(is_dir("$indir/$filename"))
                {
                    $this->checksize("$indir/$filename");
                }
                else
                {
                    $this->totalsize=$this->totalsize + filesize("$indir/$filename");
                }
            }
        }
    }

    function setkb($size)
    {
        $size=$size/1024;

        if($size>0)
        {
            list($t1,$t2)=explode(".",$size);
            $size=$t1.".".substr($t2,0,1);
        }
        return $size;
    }

    function setmb($size)
    {
        $size=$size/1024/1024;
        if($size>0)
        {
            list($t1,$t2)=explode(".",$size);
            $size=$t1.".".substr($t2,0,2);
        }
        return $size;
    }
}