<?php

/**
 * This action is used to update one or more campaigns (delete, ...)
 *
 * @package		backend
 * @subpackage	mailmotor
 *
 * @author		Dave Lens <dave@netlash.com>
 * @since		2.0
 */
class BackendMailmotorMassCampaignAction extends BackendBaseAction
{
	/**
	 * Execute the action
	 *
	 * @return	void
	 */
	public function execute()
	{
		// call parent, this will probably add some general CSS/JS or other required files
		parent::execute();

		// action to execute
		$action = SpoonFilter::getGetValue('action', array('delete'), 'delete');

		// no id's provided
		if(!isset($_GET['id'])) $this->redirect(BackendModel::createURLForAction('campaigns') . '&error=no-items-selected');

		// at least one id
		else
		{
			// redefine id's
			$ids = (array) $_GET['id'];

			// delete comment(s)
			if($action == 'delete')
			{
				BackendMailmotorModel::deleteCampaigns($ids);

				// trigger event
				BackendModel::triggerEvent($this->getModule(), 'after_delete_campaigns', array('ids' => $ids));
			}
		}

		// redirect
		$this->redirect(BackendModel::createURLForAction('campaigns') . '&report=delete-campaigns');
	}
}

?>