/*
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
$(document).ready(function() {

    $(".click-title").mouseenter( function(    e){
        e.preventDefault();
        this.style.cursor="pointer";
    });
    $(".click-title").mousedown( function(event){
        event.preventDefault();
    });

    // Ugly code while this script is shared among several pages
    try{
        refreshHitsPerSecond(true);
    } catch(e){}
    try{
        refreshResponseTimeOverTime(true);
    } catch(e){}
    try{
        refreshResponseTimePercentiles();
    } catch(e){}
});


var responseTimePercentilesInfos = {
        data: {"result": {"minY": 648.0, "minX": 0.0, "maxY": 2511.0, "series": [{"data": [[0.0, 648.0], [0.1, 648.0], [0.2, 648.0], [0.3, 648.0], [0.4, 676.0], [0.5, 676.0], [0.6, 676.0], [0.7, 786.0], [0.8, 786.0], [0.9, 786.0], [1.0, 786.0], [1.1, 789.0], [1.2, 789.0], [1.3, 789.0], [1.4, 794.0], [1.5, 794.0], [1.6, 794.0], [1.7, 794.0], [1.8, 800.0], [1.9, 800.0], [2.0, 800.0], [2.1, 800.0], [2.2, 800.0], [2.3, 800.0], [2.4, 800.0], [2.5, 802.0], [2.6, 802.0], [2.7, 802.0], [2.8, 803.0], [2.9, 803.0], [3.0, 803.0], [3.1, 803.0], [3.2, 815.0], [3.3, 815.0], [3.4, 815.0], [3.5, 815.0], [3.6, 815.0], [3.7, 815.0], [3.8, 815.0], [3.9, 816.0], [4.0, 816.0], [4.1, 816.0], [4.2, 820.0], [4.3, 820.0], [4.4, 820.0], [4.5, 820.0], [4.6, 820.0], [4.7, 820.0], [4.8, 820.0], [4.9, 824.0], [5.0, 824.0], [5.1, 824.0], [5.2, 826.0], [5.3, 826.0], [5.4, 826.0], [5.5, 826.0], [5.6, 826.0], [5.7, 826.0], [5.8, 826.0], [5.9, 827.0], [6.0, 827.0], [6.1, 827.0], [6.2, 827.0], [6.3, 835.0], [6.4, 835.0], [6.5, 835.0], [6.6, 854.0], [6.7, 854.0], [6.8, 854.0], [6.9, 854.0], [7.0, 857.0], [7.1, 857.0], [7.2, 857.0], [7.3, 857.0], [7.4, 857.0], [7.5, 857.0], [7.6, 857.0], [7.7, 859.0], [7.8, 859.0], [7.9, 859.0], [8.0, 860.0], [8.1, 860.0], [8.2, 860.0], [8.3, 860.0], [8.4, 861.0], [8.5, 861.0], [8.6, 861.0], [8.7, 863.0], [8.8, 863.0], [8.9, 863.0], [9.0, 864.0], [9.1, 864.0], [9.2, 864.0], [9.3, 864.0], [9.4, 867.0], [9.5, 867.0], [9.6, 867.0], [9.7, 867.0], [9.8, 867.0], [9.9, 867.0], [10.0, 867.0], [10.1, 871.0], [10.2, 871.0], [10.3, 871.0], [10.4, 872.0], [10.5, 872.0], [10.6, 872.0], [10.7, 872.0], [10.8, 874.0], [10.9, 874.0], [11.0, 874.0], [11.1, 877.0], [11.2, 877.0], [11.3, 877.0], [11.4, 877.0], [11.5, 878.0], [11.6, 878.0], [11.7, 878.0], [11.8, 886.0], [11.9, 886.0], [12.0, 886.0], [12.1, 886.0], [12.2, 889.0], [12.3, 889.0], [12.4, 889.0], [12.5, 889.0], [12.6, 889.0], [12.7, 889.0], [12.8, 889.0], [12.9, 889.0], [13.0, 889.0], [13.1, 889.0], [13.2, 891.0], [13.3, 891.0], [13.4, 891.0], [13.5, 892.0], [13.6, 892.0], [13.7, 892.0], [13.8, 892.0], [13.9, 893.0], [14.0, 893.0], [14.1, 893.0], [14.2, 897.0], [14.3, 897.0], [14.4, 897.0], [14.5, 897.0], [14.6, 901.0], [14.7, 901.0], [14.8, 901.0], [14.9, 901.0], [15.0, 901.0], [15.1, 901.0], [15.2, 901.0], [15.3, 903.0], [15.4, 903.0], [15.5, 903.0], [15.6, 904.0], [15.7, 904.0], [15.8, 904.0], [15.9, 904.0], [16.0, 905.0], [16.1, 905.0], [16.2, 905.0], [16.3, 905.0], [16.4, 905.0], [16.5, 905.0], [16.6, 905.0], [16.7, 905.0], [16.8, 905.0], [16.9, 905.0], [17.0, 906.0], [17.1, 906.0], [17.2, 906.0], [17.3, 906.0], [17.4, 907.0], [17.5, 907.0], [17.6, 907.0], [17.7, 909.0], [17.8, 909.0], [17.9, 909.0], [18.0, 913.0], [18.1, 913.0], [18.2, 913.0], [18.3, 913.0], [18.4, 914.0], [18.5, 914.0], [18.6, 914.0], [18.7, 914.0], [18.8, 914.0], [18.9, 914.0], [19.0, 914.0], [19.1, 916.0], [19.2, 916.0], [19.3, 916.0], [19.4, 916.0], [19.5, 916.0], [19.6, 916.0], [19.7, 916.0], [19.8, 917.0], [19.9, 917.0], [20.0, 917.0], [20.1, 917.0], [20.2, 917.0], [20.3, 917.0], [20.4, 917.0], [20.5, 918.0], [20.6, 918.0], [20.7, 918.0], [20.8, 919.0], [20.9, 919.0], [21.0, 919.0], [21.1, 919.0], [21.2, 919.0], [21.3, 919.0], [21.4, 919.0], [21.5, 919.0], [21.6, 919.0], [21.7, 919.0], [21.8, 921.0], [21.9, 921.0], [22.0, 921.0], [22.1, 921.0], [22.2, 921.0], [22.3, 921.0], [22.4, 921.0], [22.5, 924.0], [22.6, 924.0], [22.7, 924.0], [22.8, 924.0], [22.9, 926.0], [23.0, 926.0], [23.1, 926.0], [23.2, 927.0], [23.3, 927.0], [23.4, 927.0], [23.5, 927.0], [23.6, 929.0], [23.7, 929.0], [23.8, 929.0], [23.9, 930.0], [24.0, 930.0], [24.1, 930.0], [24.2, 930.0], [24.3, 934.0], [24.4, 934.0], [24.5, 934.0], [24.6, 934.0], [24.7, 934.0], [24.8, 934.0], [24.9, 934.0], [25.0, 935.0], [25.1, 935.0], [25.2, 935.0], [25.3, 936.0], [25.4, 936.0], [25.5, 936.0], [25.6, 936.0], [25.7, 936.0], [25.8, 936.0], [25.9, 936.0], [26.0, 937.0], [26.1, 937.0], [26.2, 937.0], [26.3, 937.0], [26.4, 937.0], [26.5, 937.0], [26.6, 937.0], [26.7, 938.0], [26.8, 938.0], [26.9, 938.0], [27.0, 939.0], [27.1, 939.0], [27.2, 939.0], [27.3, 939.0], [27.4, 939.0], [27.5, 939.0], [27.6, 939.0], [27.7, 940.0], [27.8, 940.0], [27.9, 940.0], [28.0, 940.0], [28.1, 940.0], [28.2, 940.0], [28.3, 940.0], [28.4, 943.0], [28.5, 943.0], [28.6, 943.0], [28.7, 943.0], [28.8, 945.0], [28.9, 945.0], [29.0, 945.0], [29.1, 947.0], [29.2, 947.0], [29.3, 947.0], [29.4, 947.0], [29.5, 948.0], [29.6, 948.0], [29.7, 948.0], [29.8, 948.0], [29.9, 948.0], [30.0, 948.0], [30.1, 948.0], [30.2, 948.0], [30.3, 948.0], [30.4, 948.0], [30.5, 949.0], [30.6, 949.0], [30.7, 949.0], [30.8, 949.0], [30.9, 949.0], [31.0, 949.0], [31.1, 949.0], [31.2, 953.0], [31.3, 953.0], [31.4, 953.0], [31.5, 953.0], [31.6, 953.0], [31.7, 953.0], [31.8, 953.0], [31.9, 953.0], [32.0, 953.0], [32.1, 953.0], [32.2, 954.0], [32.3, 954.0], [32.4, 954.0], [32.5, 954.0], [32.6, 956.0], [32.7, 956.0], [32.8, 956.0], [32.9, 957.0], [33.0, 957.0], [33.1, 957.0], [33.2, 957.0], [33.3, 957.0], [33.4, 957.0], [33.5, 957.0], [33.6, 957.0], [33.7, 957.0], [33.8, 957.0], [33.9, 957.0], [34.0, 958.0], [34.1, 958.0], [34.2, 958.0], [34.3, 958.0], [34.4, 958.0], [34.5, 958.0], [34.6, 958.0], [34.7, 961.0], [34.8, 961.0], [34.9, 961.0], [35.0, 962.0], [35.1, 962.0], [35.2, 962.0], [35.3, 962.0], [35.4, 962.0], [35.5, 962.0], [35.6, 962.0], [35.7, 963.0], [35.8, 963.0], [35.9, 963.0], [36.0, 963.0], [36.1, 963.0], [36.2, 963.0], [36.3, 963.0], [36.4, 965.0], [36.5, 965.0], [36.6, 965.0], [36.7, 965.0], [36.8, 965.0], [36.9, 965.0], [37.0, 965.0], [37.1, 966.0], [37.2, 966.0], [37.3, 966.0], [37.4, 966.0], [37.5, 966.0], [37.6, 966.0], [37.7, 966.0], [37.8, 967.0], [37.9, 967.0], [38.0, 967.0], [38.1, 967.0], [38.2, 967.0], [38.3, 967.0], [38.4, 967.0], [38.5, 971.0], [38.6, 971.0], [38.7, 971.0], [38.8, 971.0], [38.9, 971.0], [39.0, 971.0], [39.1, 971.0], [39.2, 972.0], [39.3, 972.0], [39.4, 972.0], [39.5, 973.0], [39.6, 973.0], [39.7, 973.0], [39.8, 973.0], [39.9, 973.0], [40.0, 973.0], [40.1, 973.0], [40.2, 973.0], [40.3, 973.0], [40.4, 973.0], [40.5, 974.0], [40.6, 974.0], [40.7, 974.0], [40.8, 974.0], [40.9, 975.0], [41.0, 975.0], [41.1, 975.0], [41.2, 976.0], [41.3, 976.0], [41.4, 976.0], [41.5, 976.0], [41.6, 977.0], [41.7, 977.0], [41.8, 977.0], [41.9, 977.0], [42.0, 977.0], [42.1, 977.0], [42.2, 977.0], [42.3, 977.0], [42.4, 977.0], [42.5, 977.0], [42.6, 980.0], [42.7, 980.0], [42.8, 980.0], [42.9, 980.0], [43.0, 980.0], [43.1, 980.0], [43.2, 980.0], [43.3, 983.0], [43.4, 983.0], [43.5, 983.0], [43.6, 984.0], [43.7, 984.0], [43.8, 984.0], [43.9, 984.0], [44.0, 985.0], [44.1, 985.0], [44.2, 985.0], [44.3, 985.0], [44.4, 985.0], [44.5, 985.0], [44.6, 985.0], [44.7, 986.0], [44.8, 986.0], [44.9, 986.0], [45.0, 989.0], [45.1, 989.0], [45.2, 989.0], [45.3, 989.0], [45.4, 990.0], [45.5, 990.0], [45.6, 990.0], [45.7, 993.0], [45.8, 993.0], [45.9, 993.0], [46.0, 993.0], [46.1, 993.0], [46.2, 993.0], [46.3, 993.0], [46.4, 994.0], [46.5, 994.0], [46.6, 994.0], [46.7, 994.0], [46.8, 994.0], [46.9, 994.0], [47.0, 994.0], [47.1, 994.0], [47.2, 994.0], [47.3, 994.0], [47.4, 994.0], [47.5, 995.0], [47.6, 995.0], [47.7, 995.0], [47.8, 996.0], [47.9, 996.0], [48.0, 996.0], [48.1, 999.0], [48.2, 999.0], [48.3, 999.0], [48.4, 999.0], [48.5, 1000.0], [48.6, 1000.0], [48.7, 1000.0], [48.8, 1002.0], [48.9, 1002.0], [49.0, 1002.0], [49.1, 1002.0], [49.2, 1002.0], [49.3, 1002.0], [49.4, 1002.0], [49.5, 1003.0], [49.6, 1003.0], [49.7, 1003.0], [49.8, 1003.0], [49.9, 1003.0], [50.0, 1003.0], [50.1, 1003.0], [50.2, 1004.0], [50.3, 1004.0], [50.4, 1004.0], [50.5, 1004.0], [50.6, 1004.0], [50.7, 1004.0], [50.8, 1004.0], [50.9, 1005.0], [51.0, 1005.0], [51.1, 1005.0], [51.2, 1005.0], [51.3, 1005.0], [51.4, 1005.0], [51.5, 1005.0], [51.6, 1008.0], [51.7, 1008.0], [51.8, 1008.0], [51.9, 1008.0], [52.0, 1008.0], [52.1, 1008.0], [52.2, 1008.0], [52.3, 1008.0], [52.4, 1008.0], [52.5, 1008.0], [52.6, 1009.0], [52.7, 1009.0], [52.8, 1009.0], [52.9, 1009.0], [53.0, 1010.0], [53.1, 1010.0], [53.2, 1010.0], [53.3, 1011.0], [53.4, 1011.0], [53.5, 1011.0], [53.6, 1011.0], [53.7, 1012.0], [53.8, 1012.0], [53.9, 1012.0], [54.0, 1012.0], [54.1, 1012.0], [54.2, 1012.0], [54.3, 1012.0], [54.4, 1013.0], [54.5, 1013.0], [54.6, 1013.0], [54.7, 1015.0], [54.8, 1015.0], [54.9, 1015.0], [55.0, 1015.0], [55.1, 1016.0], [55.2, 1016.0], [55.3, 1016.0], [55.4, 1017.0], [55.5, 1017.0], [55.6, 1017.0], [55.7, 1017.0], [55.8, 1017.0], [55.9, 1017.0], [56.0, 1017.0], [56.1, 1019.0], [56.2, 1019.0], [56.3, 1019.0], [56.4, 1019.0], [56.5, 1020.0], [56.6, 1020.0], [56.7, 1020.0], [56.8, 1021.0], [56.9, 1021.0], [57.0, 1021.0], [57.1, 1024.0], [57.2, 1024.0], [57.3, 1024.0], [57.4, 1024.0], [57.5, 1025.0], [57.6, 1025.0], [57.7, 1025.0], [57.8, 1028.0], [57.9, 1028.0], [58.0, 1028.0], [58.1, 1028.0], [58.2, 1028.0], [58.3, 1028.0], [58.4, 1028.0], [58.5, 1032.0], [58.6, 1032.0], [58.7, 1032.0], [58.8, 1032.0], [58.9, 1035.0], [59.0, 1035.0], [59.1, 1035.0], [59.2, 1036.0], [59.3, 1036.0], [59.4, 1036.0], [59.5, 1036.0], [59.6, 1038.0], [59.7, 1038.0], [59.8, 1038.0], [59.9, 1039.0], [60.0, 1039.0], [60.1, 1039.0], [60.2, 1039.0], [60.3, 1040.0], [60.4, 1040.0], [60.5, 1040.0], [60.6, 1042.0], [60.7, 1042.0], [60.8, 1042.0], [60.9, 1042.0], [61.0, 1042.0], [61.1, 1042.0], [61.2, 1042.0], [61.3, 1042.0], [61.4, 1042.0], [61.5, 1042.0], [61.6, 1043.0], [61.7, 1043.0], [61.8, 1043.0], [61.9, 1043.0], [62.0, 1043.0], [62.1, 1043.0], [62.2, 1043.0], [62.3, 1044.0], [62.4, 1044.0], [62.5, 1044.0], [62.6, 1044.0], [62.7, 1046.0], [62.8, 1046.0], [62.9, 1046.0], [63.0, 1047.0], [63.1, 1047.0], [63.2, 1047.0], [63.3, 1047.0], [63.4, 1048.0], [63.5, 1048.0], [63.6, 1048.0], [63.7, 1050.0], [63.8, 1050.0], [63.9, 1050.0], [64.0, 1050.0], [64.1, 1050.0], [64.2, 1050.0], [64.3, 1050.0], [64.4, 1051.0], [64.5, 1051.0], [64.6, 1051.0], [64.7, 1051.0], [64.8, 1051.0], [64.9, 1051.0], [65.0, 1051.0], [65.1, 1052.0], [65.2, 1052.0], [65.3, 1052.0], [65.4, 1054.0], [65.5, 1054.0], [65.6, 1054.0], [65.7, 1054.0], [65.8, 1054.0], [65.9, 1054.0], [66.0, 1054.0], [66.1, 1056.0], [66.2, 1056.0], [66.3, 1056.0], [66.4, 1056.0], [66.5, 1057.0], [66.6, 1057.0], [66.7, 1057.0], [66.8, 1059.0], [66.9, 1059.0], [67.0, 1059.0], [67.1, 1059.0], [67.2, 1059.0], [67.3, 1059.0], [67.4, 1059.0], [67.5, 1061.0], [67.6, 1061.0], [67.7, 1061.0], [67.8, 1061.0], [67.9, 1062.0], [68.0, 1062.0], [68.1, 1062.0], [68.2, 1062.0], [68.3, 1062.0], [68.4, 1062.0], [68.5, 1062.0], [68.6, 1063.0], [68.7, 1063.0], [68.8, 1063.0], [68.9, 1063.0], [69.0, 1063.0], [69.1, 1063.0], [69.2, 1063.0], [69.3, 1064.0], [69.4, 1064.0], [69.5, 1064.0], [69.6, 1066.0], [69.7, 1066.0], [69.8, 1066.0], [69.9, 1067.0], [70.0, 1067.0], [70.1, 1067.0], [70.2, 1067.0], [70.3, 1068.0], [70.4, 1068.0], [70.5, 1068.0], [70.6, 1069.0], [70.7, 1069.0], [70.8, 1069.0], [70.9, 1069.0], [71.0, 1069.0], [71.1, 1069.0], [71.2, 1069.0], [71.3, 1070.0], [71.4, 1070.0], [71.5, 1070.0], [71.6, 1070.0], [71.7, 1071.0], [71.8, 1071.0], [71.9, 1071.0], [72.0, 1074.0], [72.1, 1074.0], [72.2, 1074.0], [72.3, 1074.0], [72.4, 1075.0], [72.5, 1075.0], [72.6, 1075.0], [72.7, 1076.0], [72.8, 1076.0], [72.9, 1076.0], [73.0, 1076.0], [73.1, 1079.0], [73.2, 1079.0], [73.3, 1079.0], [73.4, 1083.0], [73.5, 1083.0], [73.6, 1083.0], [73.7, 1083.0], [73.8, 1088.0], [73.9, 1088.0], [74.0, 1088.0], [74.1, 1090.0], [74.2, 1090.0], [74.3, 1090.0], [74.4, 1093.0], [74.5, 1093.0], [74.6, 1093.0], [74.7, 1093.0], [74.8, 1093.0], [74.9, 1093.0], [75.0, 1093.0], [75.1, 1095.0], [75.2, 1095.0], [75.3, 1095.0], [75.4, 1095.0], [75.5, 1095.0], [75.6, 1095.0], [75.7, 1095.0], [75.8, 1097.0], [75.9, 1097.0], [76.0, 1097.0], [76.1, 1097.0], [76.2, 1098.0], [76.3, 1098.0], [76.4, 1098.0], [76.5, 1101.0], [76.6, 1101.0], [76.7, 1101.0], [76.8, 1101.0], [76.9, 1102.0], [77.0, 1102.0], [77.1, 1102.0], [77.2, 1104.0], [77.3, 1104.0], [77.4, 1104.0], [77.5, 1104.0], [77.6, 1105.0], [77.7, 1105.0], [77.8, 1105.0], [77.9, 1106.0], [78.0, 1106.0], [78.1, 1106.0], [78.2, 1106.0], [78.3, 1108.0], [78.4, 1108.0], [78.5, 1108.0], [78.6, 1110.0], [78.7, 1110.0], [78.8, 1110.0], [78.9, 1111.0], [79.0, 1111.0], [79.1, 1111.0], [79.2, 1111.0], [79.3, 1111.0], [79.4, 1111.0], [79.5, 1111.0], [79.6, 1112.0], [79.7, 1112.0], [79.8, 1112.0], [79.9, 1112.0], [80.0, 1115.0], [80.1, 1115.0], [80.2, 1115.0], [80.3, 1119.0], [80.4, 1119.0], [80.5, 1119.0], [80.6, 1119.0], [80.7, 1121.0], [80.8, 1121.0], [80.9, 1121.0], [81.0, 1123.0], [81.1, 1123.0], [81.2, 1123.0], [81.3, 1123.0], [81.4, 1123.0], [81.5, 1123.0], [81.6, 1123.0], [81.7, 1125.0], [81.8, 1125.0], [81.9, 1125.0], [82.0, 1125.0], [82.1, 1127.0], [82.2, 1127.0], [82.3, 1127.0], [82.4, 1127.0], [82.5, 1127.0], [82.6, 1127.0], [82.7, 1129.0], [82.8, 1129.0], [82.9, 1129.0], [83.0, 1129.0], [83.1, 1132.0], [83.2, 1132.0], [83.3, 1132.0], [83.4, 1138.0], [83.5, 1138.0], [83.6, 1138.0], [83.7, 1138.0], [83.8, 1144.0], [83.9, 1144.0], [84.0, 1144.0], [84.1, 1147.0], [84.2, 1147.0], [84.3, 1147.0], [84.4, 1147.0], [84.5, 1148.0], [84.6, 1148.0], [84.7, 1148.0], [84.8, 1154.0], [84.9, 1154.0], [85.0, 1154.0], [85.1, 1154.0], [85.2, 1154.0], [85.3, 1154.0], [85.4, 1154.0], [85.5, 1158.0], [85.6, 1158.0], [85.7, 1158.0], [85.8, 1158.0], [85.9, 1161.0], [86.0, 1161.0], [86.1, 1161.0], [86.2, 1161.0], [86.3, 1161.0], [86.4, 1161.0], [86.5, 1161.0], [86.6, 1162.0], [86.7, 1162.0], [86.8, 1162.0], [86.9, 1162.0], [87.0, 1162.0], [87.1, 1162.0], [87.2, 1163.0], [87.3, 1163.0], [87.4, 1163.0], [87.5, 1163.0], [87.6, 1167.0], [87.7, 1167.0], [87.8, 1167.0], [87.9, 1168.0], [88.0, 1168.0], [88.1, 1168.0], [88.2, 1168.0], [88.3, 1177.0], [88.4, 1177.0], [88.5, 1177.0], [88.6, 1177.0], [88.7, 1177.0], [88.8, 1177.0], [88.9, 1177.0], [89.0, 1181.0], [89.1, 1181.0], [89.2, 1181.0], [89.3, 1184.0], [89.4, 1184.0], [89.5, 1184.0], [89.6, 1184.0], [89.7, 1192.0], [89.8, 1192.0], [89.9, 1192.0], [90.0, 1198.0], [90.1, 1198.0], [90.2, 1198.0], [90.3, 1198.0], [90.4, 1212.0], [90.5, 1212.0], [90.6, 1212.0], [90.7, 1218.0], [90.8, 1218.0], [90.9, 1218.0], [91.0, 1218.0], [91.1, 1227.0], [91.2, 1227.0], [91.3, 1227.0], [91.4, 1231.0], [91.5, 1231.0], [91.6, 1231.0], [91.7, 1234.0], [91.8, 1234.0], [91.9, 1234.0], [92.0, 1234.0], [92.1, 1235.0], [92.2, 1235.0], [92.3, 1235.0], [92.4, 1240.0], [92.5, 1240.0], [92.6, 1240.0], [92.7, 1240.0], [92.8, 1246.0], [92.9, 1246.0], [93.0, 1246.0], [93.1, 1246.0], [93.2, 1246.0], [93.3, 1246.0], [93.4, 1246.0], [93.5, 1251.0], [93.6, 1251.0], [93.7, 1251.0], [93.8, 1257.0], [93.9, 1257.0], [94.0, 1257.0], [94.1, 1257.0], [94.2, 1258.0], [94.3, 1258.0], [94.4, 1258.0], [94.5, 1261.0], [94.6, 1261.0], [94.7, 1261.0], [94.8, 1261.0], [94.9, 1262.0], [95.0, 1262.0], [95.1, 1262.0], [95.2, 1270.0], [95.3, 1270.0], [95.4, 1270.0], [95.5, 1270.0], [95.6, 1272.0], [95.7, 1272.0], [95.8, 1272.0], [95.9, 1274.0], [96.0, 1274.0], [96.1, 1274.0], [96.2, 1280.0], [96.3, 1280.0], [96.4, 1280.0], [96.5, 1280.0], [96.6, 1330.0], [96.7, 1330.0], [96.8, 1330.0], [96.9, 1359.0], [97.0, 1359.0], [97.1, 1359.0], [97.2, 1359.0], [97.3, 1381.0], [97.4, 1381.0], [97.5, 1381.0], [97.6, 1616.0], [97.7, 1616.0], [97.8, 1616.0], [97.9, 1616.0], [98.0, 1622.0], [98.1, 1622.0], [98.2, 1622.0], [98.3, 1699.0], [98.4, 1699.0], [98.5, 1699.0], [98.6, 1699.0], [98.7, 1792.0], [98.8, 1792.0], [98.9, 1792.0], [99.0, 1818.0], [99.1, 1818.0], [99.2, 1818.0], [99.3, 1818.0], [99.4, 2023.0], [99.5, 2023.0], [99.6, 2023.0], [99.7, 2511.0], [99.8, 2511.0], [99.9, 2511.0]], "isOverall": false, "label": "downloaddFile", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 100.0, "title": "Response Time Percentiles"}},
        getOptions: function() {
            return {
                series: {
                    points: { show: false }
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentiles'
                },
                xaxis: {
                    tickDecimals: 1,
                    axisLabel: "Percentiles",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Percentile value in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : %x.2 percentile was %y ms"
                },
                selection: { mode: "xy" },
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentiles"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesPercentiles"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesPercentiles"), dataset, prepareOverviewOptions(options));
        }
};

/**
 * @param elementId Id of element where we display message
 */
function setEmptyGraph(elementId) {
    $(function() {
        $(elementId).text("No graph series with filter="+seriesFilter);
    });
}

// Response times percentiles
function refreshResponseTimePercentiles() {
    var infos = responseTimePercentilesInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimePercentiles");
        return;
    }
    if (isGraph($("#flotResponseTimesPercentiles"))){
        infos.createGraph();
    } else {
        var choiceContainer = $("#choicesResponseTimePercentiles");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesPercentiles", "#overviewResponseTimesPercentiles");
        $('#bodyResponseTimePercentiles .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimeDistributionInfos = {
        data: {"result": {"minY": 1.0, "minX": 600.0, "maxY": 98.0, "series": [{"data": [[600.0, 2.0], [2500.0, 1.0], [700.0, 3.0], [800.0, 37.0], [900.0, 98.0], [1000.0, 81.0], [1100.0, 40.0], [1200.0, 18.0], [1300.0, 3.0], [1600.0, 3.0], [1700.0, 1.0], [1800.0, 1.0], [2000.0, 1.0]], "isOverall": false, "label": "downloaddFile", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 100, "maxX": 2500.0, "title": "Response Time Distribution"}},
        getOptions: function() {
            var granularity = this.data.result.granularity;
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    barWidth: this.data.result.granularity
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " responses for " + label + " were between " + xval + " and " + (xval + granularity) + " ms";
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimeDistribution"), prepareData(data.result.series, $("#choicesResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshResponseTimeDistribution() {
    var infos = responseTimeDistributionInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeDistribution");
        return;
    }
    if (isGraph($("#flotResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var syntheticResponseTimeDistributionInfos = {
        data: {"result": {"minY": 7.0, "minX": 1.0, "ticks": [[0, "Requests having \nresponse time <= 500ms"], [1, "Requests having \nresponse time > 500ms and <= 1,500ms"], [2, "Requests having \nresponse time > 1,500ms"], [3, "Requests in error"]], "maxY": 282.0, "series": [{"data": [], "color": "#9ACD32", "isOverall": false, "label": "Requests having \nresponse time <= 500ms", "isController": false}, {"data": [[1.0, 282.0]], "color": "yellow", "isOverall": false, "label": "Requests having \nresponse time > 500ms and <= 1,500ms", "isController": false}, {"data": [[2.0, 7.0]], "color": "orange", "isOverall": false, "label": "Requests having \nresponse time > 1,500ms", "isController": false}, {"data": [], "color": "#FF6347", "isOverall": false, "label": "Requests in error", "isController": false}], "supportsControllersDiscrimination": false, "maxX": 2.0, "title": "Synthetic Response Times Distribution"}},
        getOptions: function() {
            return {
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendSyntheticResponseTimeDistribution'
                },
                xaxis:{
                    axisLabel: "Response times ranges",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                    tickLength:0,
                    min:-0.5,
                    max:3.5
                },
                yaxis: {
                    axisLabel: "Number of responses",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                bars : {
                    show: true,
                    align: "center",
                    barWidth: 0.25,
                    fill:.75
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: function(label, xval, yval, flotItem){
                        return yval + " " + label;
                    }
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var options = this.getOptions();
            prepareOptions(options, data);
            options.xaxis.ticks = data.result.ticks;
            $.plot($("#flotSyntheticResponseTimeDistribution"), prepareData(data.result.series, $("#choicesSyntheticResponseTimeDistribution")), options);
        }

};

// Response time distribution
function refreshSyntheticResponseTimeDistribution() {
    var infos = syntheticResponseTimeDistributionInfos;
    prepareSeries(infos.data, true);
    if (isGraph($("#flotSyntheticResponseTimeDistribution"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        $('#footerSyntheticResponseTimeDistribution .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var activeThreadsOverTimeInfos = {
        data: {"result": {"minY": 4.957805907172995, "minX": 1.58243052E12, "maxY": 5.0, "series": [{"data": [[1.58243058E12, 4.957805907172995], [1.58243052E12, 5.0]], "isOverall": false, "label": "Scenario 1", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.58243058E12, "title": "Active Threads Over Time"}},
        getOptions: function() {
            return {
                series: {
                    stack: true,
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 6,
                    show: true,
                    container: '#legendActiveThreadsOverTime'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                selection: {
                    mode: 'xy'
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : At %x there were %y active threads"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesActiveThreadsOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotActiveThreadsOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewActiveThreadsOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Active Threads Over Time
function refreshActiveThreadsOverTime(fixTimestamps) {
    var infos = activeThreadsOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotActiveThreadsOverTime"))) {
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesActiveThreadsOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotActiveThreadsOverTime", "#overviewActiveThreadsOverTime");
        $('#footerActiveThreadsOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var timeVsThreadsInfos = {
        data: {"result": {"minY": 859.0, "minX": 1.0, "maxY": 1033.207017543861, "series": [{"data": [[4.0, 914.0], [2.0, 977.0], [1.0, 859.0], [5.0, 1033.207017543861], [3.0, 897.0]], "isOverall": false, "label": "downloaddFile", "isController": false}, {"data": [[4.965397923875432, 1031.5259515570947]], "isOverall": false, "label": "downloaddFile-Aggregated", "isController": false}], "supportsControllersDiscrimination": true, "maxX": 5.0, "title": "Time VS Threads"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    axisLabel: "Number of active threads",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response times in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: { noColumns: 2,show: true, container: '#legendTimeVsThreads' },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s: At %x.2 active threads, Average response time was %y.2 ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesTimeVsThreads"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotTimesVsThreads"), dataset, options);
            // setup overview
            $.plot($("#overviewTimesVsThreads"), dataset, prepareOverviewOptions(options));
        }
};

// Time vs threads
function refreshTimeVsThreads(){
    var infos = timeVsThreadsInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTimeVsThreads");
        return;
    }
    if(isGraph($("#flotTimesVsThreads"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTimeVsThreads");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTimesVsThreads", "#overviewTimesVsThreads");
        $('#footerTimeVsThreads .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var bytesThroughputOverTimeInfos = {
        data : {"result": {"minY": 148.2, "minX": 1.58243052E12, "maxY": 3791240.816666667, "series": [{"data": [[1.58243058E12, 3791240.816666667], [1.58243052E12, 831907.7]], "isOverall": false, "label": "Bytes received per second", "isController": false}, {"data": [[1.58243058E12, 675.45], [1.58243052E12, 148.2]], "isOverall": false, "label": "Bytes sent per second", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.58243058E12, "title": "Bytes Throughput Over Time"}},
        getOptions : function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity) ,
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Bytes / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendBytesThroughputOverTime'
                },
                selection: {
                    mode: "xy"
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y"
                }
            };
        },
        createGraph : function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesBytesThroughputOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotBytesThroughputOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewBytesThroughputOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Bytes throughput Over Time
function refreshBytesThroughputOverTime(fixTimestamps) {
    var infos = bytesThroughputOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotBytesThroughputOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesBytesThroughputOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotBytesThroughputOverTime", "#overviewBytesThroughputOverTime");
        $('#footerBytesThroughputOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var responseTimesOverTimeInfos = {
        data: {"result": {"minY": 1017.3586497890295, "minX": 1.58243052E12, "maxY": 1096.0961538461538, "series": [{"data": [[1.58243058E12, 1017.3586497890295], [1.58243052E12, 1096.0961538461538]], "isOverall": false, "label": "downloaddFile", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.58243058E12, "title": "Response Time Over Time"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average response time was %y ms"
                }
            };
        },
        createGraph: function() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Times Over Time
function refreshResponseTimeOverTime(fixTimestamps) {
    var infos = responseTimesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyResponseTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotResponseTimesOverTime"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimesOverTime", "#overviewResponseTimesOverTime");
        $('#footerResponseTimesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var latenciesOverTimeInfos = {
        data: {"result": {"minY": 211.94936708860766, "minX": 1.58243052E12, "maxY": 253.0961538461538, "series": [{"data": [[1.58243058E12, 211.94936708860766], [1.58243052E12, 253.0961538461538]], "isOverall": false, "label": "downloaddFile", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.58243058E12, "title": "Latencies Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average response latencies in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendLatenciesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average latency was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesLatenciesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotLatenciesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewLatenciesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Latencies Over Time
function refreshLatenciesOverTime(fixTimestamps) {
    var infos = latenciesOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyLatenciesOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotLatenciesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesLatenciesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotLatenciesOverTime", "#overviewLatenciesOverTime");
        $('#footerLatenciesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var connectTimeOverTimeInfos = {
        data: {"result": {"minY": 102.75105485232069, "minX": 1.58243052E12, "maxY": 118.28846153846153, "series": [{"data": [[1.58243058E12, 102.75105485232069], [1.58243052E12, 118.28846153846153]], "isOverall": false, "label": "downloaddFile", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.58243058E12, "title": "Connect Time Over Time"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getConnectTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Average Connect Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendConnectTimeOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Average connect time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesConnectTimeOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotConnectTimeOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewConnectTimeOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Connect Time Over Time
function refreshConnectTimeOverTime(fixTimestamps) {
    var infos = connectTimeOverTimeInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyConnectTimeOverTime");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotConnectTimeOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesConnectTimeOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotConnectTimeOverTime", "#overviewConnectTimeOverTime");
        $('#footerConnectTimeOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var responseTimePercentilesOverTimeInfos = {
        data: {"result": {"minY": 648.0, "minX": 1.58243052E12, "maxY": 2511.0, "series": [{"data": [[1.58243058E12, 2511.0], [1.58243052E12, 1699.0]], "isOverall": false, "label": "Max", "isController": false}, {"data": [[1.58243058E12, 789.0], [1.58243052E12, 648.0]], "isOverall": false, "label": "Min", "isController": false}, {"data": [[1.58243058E12, 1161.4], [1.58243052E12, 1269.0]], "isOverall": false, "label": "90th percentile", "isController": false}, {"data": [[1.58243058E12, 1945.1000000000008], [1.58243052E12, 1699.0]], "isOverall": false, "label": "99th percentile", "isController": false}, {"data": [[1.58243058E12, 1251.7], [1.58243052E12, 1347.8499999999997]], "isOverall": false, "label": "95th percentile", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.58243058E12, "title": "Response Time Percentiles Over Time (successful requests only)"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true,
                        fill: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Response Time in ms",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: '#legendResponseTimePercentilesOverTime'
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s : at %x Response time was %y ms"
                }
            };
        },
        createGraph: function () {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesResponseTimePercentilesOverTime"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotResponseTimePercentilesOverTime"), dataset, options);
            // setup overview
            $.plot($("#overviewResponseTimePercentilesOverTime"), dataset, prepareOverviewOptions(options));
        }
};

// Response Time Percentiles Over Time
function refreshResponseTimePercentilesOverTime(fixTimestamps) {
    var infos = responseTimePercentilesOverTimeInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotResponseTimePercentilesOverTime"))) {
        infos.createGraph();
    }else {
        var choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimePercentilesOverTime", "#overviewResponseTimePercentilesOverTime");
        $('#footerResponseTimePercentilesOverTime .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var responseTimeVsRequestInfos = {
    data: {"result": {"minY": 889.0, "minX": 2.0, "maxY": 1020.5, "series": [{"data": [[2.0, 889.0], [4.0, 1020.5], [5.0, 1013.0], [3.0, 962.5], [6.0, 929.0]], "isOverall": false, "label": "Successes", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 6.0, "title": "Response Time Vs Request"}},
    getOptions: function() {
        return {
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Response Time in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: {
                noColumns: 2,
                show: true,
                container: '#legendResponseTimeVsRequest'
            },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median response time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesResponseTimeVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotResponseTimeVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewResponseTimeVsRequest"), dataset, prepareOverviewOptions(options));

    }
};

// Response Time vs Request
function refreshResponseTimeVsRequest() {
    var infos = responseTimeVsRequestInfos;
    prepareSeries(infos.data);
    if (isGraph($("#flotResponseTimeVsRequest"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesResponseTimeVsRequest");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotResponseTimeVsRequest", "#overviewResponseTimeVsRequest");
        $('#footerResponseRimeVsRequest .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};


var latenciesVsRequestInfos = {
    data: {"result": {"minY": 188.5, "minX": 2.0, "maxY": 253.5, "series": [{"data": [[2.0, 188.5], [4.0, 218.0], [5.0, 210.0], [3.0, 253.5], [6.0, 210.5]], "isOverall": false, "label": "Successes", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 1000, "maxX": 6.0, "title": "Latencies Vs Request"}},
    getOptions: function() {
        return{
            series: {
                lines: {
                    show: false
                },
                points: {
                    show: true
                }
            },
            xaxis: {
                axisLabel: "Global number of requests per second",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            yaxis: {
                axisLabel: "Median Latency in ms",
                axisLabelUseCanvas: true,
                axisLabelFontSizePixels: 12,
                axisLabelFontFamily: 'Verdana, Arial',
                axisLabelPadding: 20,
            },
            legend: { noColumns: 2,show: true, container: '#legendLatencyVsRequest' },
            selection: {
                mode: 'xy'
            },
            grid: {
                hoverable: true // IMPORTANT! this is needed for tooltip to work
            },
            tooltip: true,
            tooltipOpts: {
                content: "%s : Median Latency time at %x req/s was %y ms"
            },
            colors: ["#9ACD32", "#FF6347"]
        };
    },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesLatencyVsRequest"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotLatenciesVsRequest"), dataset, options);
        // setup overview
        $.plot($("#overviewLatenciesVsRequest"), dataset, prepareOverviewOptions(options));
    }
};

// Latencies vs Request
function refreshLatenciesVsRequest() {
        var infos = latenciesVsRequestInfos;
        prepareSeries(infos.data);
        if(isGraph($("#flotLatenciesVsRequest"))){
            infos.createGraph();
        }else{
            var choiceContainer = $("#choicesLatencyVsRequest");
            createLegend(choiceContainer, infos);
            infos.createGraph();
            setGraphZoomable("#flotLatenciesVsRequest", "#overviewLatenciesVsRequest");
            $('#footerLatenciesVsRequest .legendColorBox > div').each(function(i){
                $(this).clone().prependTo(choiceContainer.find("li").eq(i));
            });
        }
};

var hitsPerSecondInfos = {
        data: {"result": {"minY": 0.95, "minX": 1.58243052E12, "maxY": 3.8666666666666667, "series": [{"data": [[1.58243058E12, 3.8666666666666667], [1.58243052E12, 0.95]], "isOverall": false, "label": "hitsPerSecond", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.58243058E12, "title": "Hits Per Second"}},
        getOptions: function() {
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of hits / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendHitsPerSecond"
                },
                selection: {
                    mode : 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y.2 hits/sec"
                }
            };
        },
        createGraph: function createGraph() {
            var data = this.data;
            var dataset = prepareData(data.result.series, $("#choicesHitsPerSecond"));
            var options = this.getOptions();
            prepareOptions(options, data);
            $.plot($("#flotHitsPerSecond"), dataset, options);
            // setup overview
            $.plot($("#overviewHitsPerSecond"), dataset, prepareOverviewOptions(options));
        }
};

// Hits per second
function refreshHitsPerSecond(fixTimestamps) {
    var infos = hitsPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if (isGraph($("#flotHitsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesHitsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotHitsPerSecond", "#overviewHitsPerSecond");
        $('#footerHitsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
}

var codesPerSecondInfos = {
        data: {"result": {"minY": 0.8666666666666667, "minX": 1.58243052E12, "maxY": 3.95, "series": [{"data": [[1.58243058E12, 3.95], [1.58243052E12, 0.8666666666666667]], "isOverall": false, "label": "200", "isController": false}], "supportsControllersDiscrimination": false, "granularity": 60000, "maxX": 1.58243058E12, "title": "Codes Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of responses / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendCodesPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "Number of Response Codes %s at %x was %y.2 responses / sec"
                }
            };
        },
    createGraph: function() {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesCodesPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotCodesPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewCodesPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Codes per second
function refreshCodesPerSecond(fixTimestamps) {
    var infos = codesPerSecondInfos;
    prepareSeries(infos.data);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotCodesPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesCodesPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotCodesPerSecond", "#overviewCodesPerSecond");
        $('#footerCodesPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var transactionsPerSecondInfos = {
        data: {"result": {"minY": 0.8666666666666667, "minX": 1.58243052E12, "maxY": 3.95, "series": [{"data": [[1.58243058E12, 3.95], [1.58243052E12, 0.8666666666666667]], "isOverall": false, "label": "downloaddFile-success", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.58243058E12, "title": "Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTransactionsPerSecond"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                }
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTransactionsPerSecond"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTransactionsPerSecond"), dataset, options);
        // setup overview
        $.plot($("#overviewTransactionsPerSecond"), dataset, prepareOverviewOptions(options));
    }
};

// Transactions per second
function refreshTransactionsPerSecond(fixTimestamps) {
    var infos = transactionsPerSecondInfos;
    prepareSeries(infos.data);
    if(infos.data.result.series.length == 0) {
        setEmptyGraph("#bodyTransactionsPerSecond");
        return;
    }
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotTransactionsPerSecond"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTransactionsPerSecond");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTransactionsPerSecond", "#overviewTransactionsPerSecond");
        $('#footerTransactionsPerSecond .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

var totalTPSInfos = {
        data: {"result": {"minY": 0.8666666666666667, "minX": 1.58243052E12, "maxY": 3.95, "series": [{"data": [[1.58243058E12, 3.95], [1.58243052E12, 0.8666666666666667]], "isOverall": false, "label": "Transaction-success", "isController": false}, {"data": [], "isOverall": false, "label": "Transaction-failure", "isController": false}], "supportsControllersDiscrimination": true, "granularity": 60000, "maxX": 1.58243058E12, "title": "Total Transactions Per Second"}},
        getOptions: function(){
            return {
                series: {
                    lines: {
                        show: true
                    },
                    points: {
                        show: true
                    }
                },
                xaxis: {
                    mode: "time",
                    timeformat: getTimeFormat(this.data.result.granularity),
                    axisLabel: getElapsedTimeLabel(this.data.result.granularity),
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20,
                },
                yaxis: {
                    axisLabel: "Number of transactions / sec",
                    axisLabelUseCanvas: true,
                    axisLabelFontSizePixels: 12,
                    axisLabelFontFamily: 'Verdana, Arial',
                    axisLabelPadding: 20
                },
                legend: {
                    noColumns: 2,
                    show: true,
                    container: "#legendTotalTPS"
                },
                selection: {
                    mode: 'xy'
                },
                grid: {
                    hoverable: true // IMPORTANT! this is needed for tooltip to
                                    // work
                },
                tooltip: true,
                tooltipOpts: {
                    content: "%s at %x was %y transactions / sec"
                },
                colors: ["#9ACD32", "#FF6347"]
            };
        },
    createGraph: function () {
        var data = this.data;
        var dataset = prepareData(data.result.series, $("#choicesTotalTPS"));
        var options = this.getOptions();
        prepareOptions(options, data);
        $.plot($("#flotTotalTPS"), dataset, options);
        // setup overview
        $.plot($("#overviewTotalTPS"), dataset, prepareOverviewOptions(options));
    }
};

// Total Transactions per second
function refreshTotalTPS(fixTimestamps) {
    var infos = totalTPSInfos;
    // We want to ignore seriesFilter
    prepareSeries(infos.data, false, true);
    if(fixTimestamps) {
        fixTimeStamps(infos.data.result.series, -18000000);
    }
    if(isGraph($("#flotTotalTPS"))){
        infos.createGraph();
    }else{
        var choiceContainer = $("#choicesTotalTPS");
        createLegend(choiceContainer, infos);
        infos.createGraph();
        setGraphZoomable("#flotTotalTPS", "#overviewTotalTPS");
        $('#footerTotalTPS .legendColorBox > div').each(function(i){
            $(this).clone().prependTo(choiceContainer.find("li").eq(i));
        });
    }
};

// Collapse the graph matching the specified DOM element depending the collapsed
// status
function collapse(elem, collapsed){
    if(collapsed){
        $(elem).parent().find(".fa-chevron-up").removeClass("fa-chevron-up").addClass("fa-chevron-down");
    } else {
        $(elem).parent().find(".fa-chevron-down").removeClass("fa-chevron-down").addClass("fa-chevron-up");
        if (elem.id == "bodyBytesThroughputOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshBytesThroughputOverTime(true);
            }
            document.location.href="#bytesThroughputOverTime";
        } else if (elem.id == "bodyLatenciesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesOverTime(true);
            }
            document.location.href="#latenciesOverTime";
        } else if (elem.id == "bodyCustomGraph") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCustomGraph(true);
            }
            document.location.href="#responseCustomGraph";
        } else if (elem.id == "bodyConnectTimeOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshConnectTimeOverTime(true);
            }
            document.location.href="#connectTimeOverTime";
        } else if (elem.id == "bodyResponseTimePercentilesOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimePercentilesOverTime(true);
            }
            document.location.href="#responseTimePercentilesOverTime";
        } else if (elem.id == "bodyResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeDistribution();
            }
            document.location.href="#responseTimeDistribution" ;
        } else if (elem.id == "bodySyntheticResponseTimeDistribution") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshSyntheticResponseTimeDistribution();
            }
            document.location.href="#syntheticResponseTimeDistribution" ;
        } else if (elem.id == "bodyActiveThreadsOverTime") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshActiveThreadsOverTime(true);
            }
            document.location.href="#activeThreadsOverTime";
        } else if (elem.id == "bodyTimeVsThreads") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTimeVsThreads();
            }
            document.location.href="#timeVsThreads" ;
        } else if (elem.id == "bodyCodesPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshCodesPerSecond(true);
            }
            document.location.href="#codesPerSecond";
        } else if (elem.id == "bodyTransactionsPerSecond") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTransactionsPerSecond(true);
            }
            document.location.href="#transactionsPerSecond";
        } else if (elem.id == "bodyTotalTPS") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshTotalTPS(true);
            }
            document.location.href="#totalTPS";
        } else if (elem.id == "bodyResponseTimeVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshResponseTimeVsRequest();
            }
            document.location.href="#responseTimeVsRequest";
        } else if (elem.id == "bodyLatenciesVsRequest") {
            if (isGraph($(elem).find('.flot-chart-content')) == false) {
                refreshLatenciesVsRequest();
            }
            document.location.href="#latencyVsRequest";
        }
    }
}

/*
 * Activates or deactivates all series of the specified graph (represented by id parameter)
 * depending on checked argument.
 */
function toggleAll(id, checked){
    var placeholder = document.getElementById(id);

    var cases = $(placeholder).find(':checkbox');
    cases.prop('checked', checked);
    $(cases).parent().children().children().toggleClass("legend-disabled", !checked);

    var choiceContainer;
    if ( id == "choicesBytesThroughputOverTime"){
        choiceContainer = $("#choicesBytesThroughputOverTime");
        refreshBytesThroughputOverTime(false);
    } else if(id == "choicesResponseTimesOverTime"){
        choiceContainer = $("#choicesResponseTimesOverTime");
        refreshResponseTimeOverTime(false);
    }else if(id == "choicesResponseCustomGraph"){
        choiceContainer = $("#choicesResponseCustomGraph");
        refreshCustomGraph(false);
    } else if ( id == "choicesLatenciesOverTime"){
        choiceContainer = $("#choicesLatenciesOverTime");
        refreshLatenciesOverTime(false);
    } else if ( id == "choicesConnectTimeOverTime"){
        choiceContainer = $("#choicesConnectTimeOverTime");
        refreshConnectTimeOverTime(false);
    } else if ( id == "choicesResponseTimePercentilesOverTime"){
        choiceContainer = $("#choicesResponseTimePercentilesOverTime");
        refreshResponseTimePercentilesOverTime(false);
    } else if ( id == "choicesResponseTimePercentiles"){
        choiceContainer = $("#choicesResponseTimePercentiles");
        refreshResponseTimePercentiles();
    } else if(id == "choicesActiveThreadsOverTime"){
        choiceContainer = $("#choicesActiveThreadsOverTime");
        refreshActiveThreadsOverTime(false);
    } else if ( id == "choicesTimeVsThreads"){
        choiceContainer = $("#choicesTimeVsThreads");
        refreshTimeVsThreads();
    } else if ( id == "choicesSyntheticResponseTimeDistribution"){
        choiceContainer = $("#choicesSyntheticResponseTimeDistribution");
        refreshSyntheticResponseTimeDistribution();
    } else if ( id == "choicesResponseTimeDistribution"){
        choiceContainer = $("#choicesResponseTimeDistribution");
        refreshResponseTimeDistribution();
    } else if ( id == "choicesHitsPerSecond"){
        choiceContainer = $("#choicesHitsPerSecond");
        refreshHitsPerSecond(false);
    } else if(id == "choicesCodesPerSecond"){
        choiceContainer = $("#choicesCodesPerSecond");
        refreshCodesPerSecond(false);
    } else if ( id == "choicesTransactionsPerSecond"){
        choiceContainer = $("#choicesTransactionsPerSecond");
        refreshTransactionsPerSecond(false);
    } else if ( id == "choicesTotalTPS"){
        choiceContainer = $("#choicesTotalTPS");
        refreshTotalTPS(false);
    } else if ( id == "choicesResponseTimeVsRequest"){
        choiceContainer = $("#choicesResponseTimeVsRequest");
        refreshResponseTimeVsRequest();
    } else if ( id == "choicesLatencyVsRequest"){
        choiceContainer = $("#choicesLatencyVsRequest");
        refreshLatenciesVsRequest();
    }
    var color = checked ? "black" : "#818181";
    if(choiceContainer != null) {
        choiceContainer.find("label").each(function(){
            this.style.color = color;
        });
    }
}

