/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.i18n;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class PreferredLocales {
    private final List<Locale> locales;

    public PreferredLocales(List<Locale> locales) {
        if (locales == null || locales.isEmpty()) {
            locales = Collections.singletonList(Locale.ROOT);
        }
        this.locales = Collections.unmodifiableList(locales);
    }

    public PreferredLocales() {
        this(null);
    }

    public Locale getPreferredLocale() {
        return this.locales.get(0);
    }

    public List<Locale> getLocales() {
        return this.locales;
    }

    public ResourceBundle getBundleInPreferredLocale(String bundleName, ClassLoader classLoader) {
        for (Locale locale : this.locales) {
            ResourceBundle candidate;
            if (!this.matches(locale, (candidate = ResourceBundle.getBundle(bundleName, locale, classLoader)).getLocale())) continue;
            return candidate;
        }
        return ResourceBundle.getBundle(bundleName, Locale.ROOT, classLoader);
    }

    private boolean matches(Locale requested, Locale candidate) {
        return candidate.equals(requested) || !Locale.ROOT.equals(candidate) && !this.locales.contains(candidate);
    }
}

