/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.time;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.forgerock.util.Reject;

public class Duration {
    private static final Duration UNLIMITED = new Duration(Long.MAX_VALUE, TimeUnit.DAYS);
    private static final Duration ZERO = new Duration(0L, TimeUnit.SECONDS);
    private static final Set<String> UNLIMITED_TOKENS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> ZERO_TOKENS;
    private Long number;
    private TimeUnit unit;
    private static Map<String, TimeUnit> TIME_UNITS;

    static {
        UNLIMITED_TOKENS.addAll(Arrays.asList("unlimited", "indefinite", "infinity", "undefined"));
        ZERO_TOKENS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ZERO_TOKENS.addAll(Arrays.asList("zero", "disabled"));
        TIME_UNITS = new HashMap<String, TimeUnit>();
        for (String days : Arrays.asList("days", "day", "d")) {
            TIME_UNITS.put(days, TimeUnit.DAYS);
        }
        for (String hours : Arrays.asList("hours", "hour", "h")) {
            TIME_UNITS.put(hours, TimeUnit.HOURS);
        }
        for (String minutes : Arrays.asList("minutes", "minute", "min", "m")) {
            TIME_UNITS.put(minutes, TimeUnit.MINUTES);
        }
        for (String seconds : Arrays.asList("seconds", "second", "sec", "s")) {
            TIME_UNITS.put(seconds, TimeUnit.SECONDS);
        }
        for (String ms : Arrays.asList("milliseconds", "millisecond", "millisec", "millis", "milli", "ms")) {
            TIME_UNITS.put(ms, TimeUnit.MILLISECONDS);
        }
        for (String us : Arrays.asList("microseconds", "microsecond", "microsec", "micros", "micro", "us")) {
            TIME_UNITS.put(us, TimeUnit.MICROSECONDS);
        }
        for (String ns : Arrays.asList("nanoseconds", "nanosecond", "nanosec", "nanos", "nano", "ns")) {
            TIME_UNITS.put(ns, TimeUnit.NANOSECONDS);
        }
    }

    public Duration(Long number, TimeUnit unit) {
        this.number = Reject.checkNotNull(number);
        this.unit = Reject.checkNotNull(unit);
    }

    public static Duration duration(String value) {
        ArrayList<Duration> composite = new ArrayList<Duration>();
        String[] fragments = value.split(",| and ");
        if (fragments.length == 1) {
            String trimmed = fragments[0].trim();
            if (UNLIMITED_TOKENS.contains(trimmed)) {
                return UNLIMITED;
            }
            if (ZERO_TOKENS.contains(trimmed)) {
                return ZERO;
            }
        }
        String[] stringArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            String fragment = stringArray[n2];
            if ("".equals(fragment = fragment.trim())) {
                throw new IllegalArgumentException("Cannot parse empty duration, expecting '<value> <unit>' pattern");
            }
            int i = 0;
            StringBuilder numberSB = new StringBuilder();
            while (Character.isDigit(fragment.charAt(i))) {
                numberSB.append(fragment.charAt(i));
                ++i;
            }
            while (Character.isWhitespace(fragment.charAt(i))) {
                ++i;
            }
            StringBuilder unitSB = new StringBuilder();
            while (i < fragment.length() && Character.isLetter(fragment.charAt(i))) {
                unitSB.append(fragment.charAt(i));
                ++i;
            }
            Long number = Long.valueOf(numberSB.toString());
            TimeUnit unit = Duration.parseTimeUnit(unitSB.toString());
            composite.add(new Duration(number, unit));
            ++n2;
        }
        Duration duration = new Duration(0L, TimeUnit.DAYS);
        for (Duration elements : composite) {
            duration.merge(elements);
        }
        if (duration.number == 0L) {
            return ZERO;
        }
        return duration;
    }

    private void merge(Duration duration) {
        if (this.unit.ordinal() > duration.unit.ordinal()) {
            this.number = duration.unit.convert(this.number, this.unit) + duration.number;
            this.unit = duration.unit;
        } else {
            this.number = this.unit.convert(duration.number, duration.unit) + this.number;
        }
    }

    private static TimeUnit parseTimeUnit(String unit) {
        String lowercase = unit.toLowerCase(Locale.ENGLISH);
        TimeUnit timeUnit = TIME_UNITS.get(lowercase);
        if (timeUnit != null) {
            return timeUnit;
        }
        throw new IllegalArgumentException(String.format("TimeUnit %s is not recognized", unit));
    }

    public long getValue() {
        return this.number;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public Duration convertTo(TimeUnit targetUnit) {
        return new Duration(targetUnit.convert(this.number, this.unit), targetUnit);
    }

    public long to(TimeUnit targetUnit) {
        return this.convertTo(targetUnit).getValue();
    }

    public boolean isUnlimited() {
        return this == UNLIMITED;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public String toString() {
        return this.number + " " + (Object)((Object)this.unit);
    }
}

