/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

public final class ASCIICharProp
implements Comparable<ASCIICharProp> {
    private final char c;
    private final char upperCaseChar;
    private final char lowerCaseChar;
    private final boolean isUpperCaseChar;
    private final boolean isLowerCaseChar;
    private final boolean isDigit;
    private final boolean isLetter;
    private final boolean isKeyChar;
    private final boolean isCompatKeyChar;
    private final boolean isHexChar;
    private final int hexValue;
    private final int decimalValue;
    private final String stringValue;
    private static final ASCIICharProp[] CHAR_PROPS = new ASCIICharProp[128];

    public static ASCIICharProp valueOf(char c) {
        if (c < '\u0080') {
            return CHAR_PROPS[c];
        }
        return null;
    }

    public static ASCIICharProp valueOf(int c) {
        if (c >= 0 && c < 128) {
            return CHAR_PROPS[c];
        }
        return null;
    }

    private ASCIICharProp(char c) {
        this.c = c;
        this.stringValue = new String(new char[]{c});
        if (c >= 'a' && c <= 'z') {
            this.upperCaseChar = (char)(c - 32);
            this.lowerCaseChar = c;
            this.isUpperCaseChar = false;
            this.isLowerCaseChar = true;
            this.isDigit = false;
            this.isLetter = true;
            this.isKeyChar = true;
            this.isCompatKeyChar = true;
            this.decimalValue = -1;
            if (c >= 'a' && c <= 'f') {
                this.isHexChar = true;
                this.hexValue = c - 87;
            } else {
                this.isHexChar = false;
                this.hexValue = -1;
            }
        } else if (c >= 'A' && c <= 'Z') {
            this.upperCaseChar = c;
            this.lowerCaseChar = (char)(c + 32);
            this.isUpperCaseChar = true;
            this.isLowerCaseChar = false;
            this.isDigit = false;
            this.isLetter = true;
            this.isKeyChar = true;
            this.isCompatKeyChar = true;
            this.decimalValue = -1;
            if (c >= 'A' && c <= 'F') {
                this.isHexChar = true;
                this.hexValue = c - 55;
            } else {
                this.isHexChar = false;
                this.hexValue = -1;
            }
        } else if (c >= '0' && c <= '9') {
            this.upperCaseChar = c;
            this.lowerCaseChar = c;
            this.isUpperCaseChar = false;
            this.isLowerCaseChar = false;
            this.isDigit = true;
            this.isLetter = false;
            this.isKeyChar = true;
            this.isCompatKeyChar = true;
            this.isHexChar = true;
            this.hexValue = c - 48;
            this.decimalValue = c - 48;
        } else {
            this.upperCaseChar = c;
            this.lowerCaseChar = c;
            this.isUpperCaseChar = false;
            this.isLowerCaseChar = false;
            this.isDigit = false;
            this.isLetter = false;
            this.isKeyChar = c == '-';
            this.isCompatKeyChar = c == '-' || c == '.' || c == '_' || c == '=';
            this.isHexChar = false;
            this.hexValue = -1;
            this.decimalValue = -1;
        }
    }

    public char charValue() {
        return this.c;
    }

    @Override
    public int compareTo(ASCIICharProp o) {
        return this.c - o.c;
    }

    public int decimalValue() {
        return this.decimalValue;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return this.c;
    }

    public int hexValue() {
        return this.hexValue;
    }

    public boolean isDigit() {
        return this.isDigit;
    }

    public boolean isHexDigit() {
        return this.isHexChar;
    }

    public boolean isKeyChar(boolean allowCompatChars) {
        return allowCompatChars ? this.isCompatKeyChar : this.isKeyChar;
    }

    public boolean isLetter() {
        return this.isLetter;
    }

    public boolean isLowerCase() {
        return this.isLowerCaseChar;
    }

    public boolean isUpperCase() {
        return this.isUpperCaseChar;
    }

    public char toLowerCase() {
        return this.lowerCaseChar;
    }

    public String toString() {
        return this.stringValue;
    }

    public char toUpperCase() {
        return this.upperCaseChar;
    }

    static {
        for (int i = 0; i < 128; ++i) {
            ASCIICharProp.CHAR_PROPS[i] = new ASCIICharProp((char)i);
        }
    }
}

