/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.ASN1Writer;
import org.forgerock.opendj.io.AbstractASN1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteStringBuilder;

final class ASN1OutputStreamWriter
extends AbstractASN1Writer {
    private static final int BUFFER_INIT_SIZE = 32;
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final OutputStream rootStream;
    private OutputStream out;
    private final ArrayList<ByteStringBuilder> streamStack = new ArrayList();
    private int stackDepth;
    private final int maxBufferSize;

    ASN1OutputStreamWriter(OutputStream stream, int maxBufferSize) {
        this.out = stream;
        this.rootStream = stream;
        this.maxBufferSize = Math.max(maxBufferSize, 32);
        this.stackDepth = -1;
    }

    @Override
    public void close() throws IOException {
        while (this.stackDepth >= 0) {
            this.writeEndSequence();
        }
        this.rootStream.flush();
        this.streamStack.clear();
        this.rootStream.close();
    }

    @Override
    public void flush() throws IOException {
        this.rootStream.flush();
    }

    @Override
    public ASN1Writer writeBoolean(byte type, boolean booleanValue) throws IOException {
        this.out.write(type);
        this.writeLength(1);
        this.out.write(booleanValue ? -1 : 0);
        logger.trace("WRITE ASN.1 BOOLEAN(type=0x%x, length=%d, value=%s)", (Object)type, (Object)1, (Object)booleanValue);
        return this;
    }

    @Override
    public ASN1Writer writeEndSequence() throws IOException {
        OutputStream parentStream;
        if (this.stackDepth < 0) {
            LocalizableMessage message = CoreMessages.ERR_ASN1_SEQUENCE_WRITE_NOT_STARTED.get();
            throw new IllegalStateException(message.toString());
        }
        ByteStringBuilder childStream = this.streamStack.get(this.stackDepth);
        --this.stackDepth;
        this.out = parentStream = this.stackDepth < 0 ? this.rootStream : this.streamStack.get(this.stackDepth).asOutputStream();
        this.writeLength(childStream.length());
        childStream.copyTo(parentStream);
        logger.trace("WRITE ASN.1 END SEQUENCE(length=%d)", (Object)childStream.length());
        childStream.clearAndTruncate(this.maxBufferSize, 32);
        return this;
    }

    @Override
    public ASN1Writer writeEndSet() throws IOException {
        return this.writeEndSequence();
    }

    @Override
    public ASN1Writer writeEnumerated(byte type, int intValue) throws IOException {
        return this.writeInteger(type, intValue);
    }

    @Override
    public ASN1Writer writeInteger(byte type, int intValue) throws IOException {
        this.out.write(type);
        if (intValue < 0 && (intValue & 0xFFFFFF80) == -128 || (intValue & 0x7F) == intValue) {
            this.writeLength(1);
            this.out.write((byte)(intValue & 0xFF));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)1, (Object)intValue);
        } else if (intValue < 0 && (intValue & Short.MIN_VALUE) == Short.MIN_VALUE || (intValue & Short.MAX_VALUE) == intValue) {
            this.writeLength(2);
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)2, (Object)intValue);
        } else if (intValue < 0 && (intValue & 0xFF800000) == -8388608 || (intValue & 0x7FFFFF) == intValue) {
            this.writeLength(3);
            this.out.write((byte)(intValue >> 16 & 0xFF));
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)3, (Object)intValue);
        } else {
            this.writeLength(4);
            this.out.write((byte)(intValue >> 24 & 0xFF));
            this.out.write((byte)(intValue >> 16 & 0xFF));
            this.out.write((byte)(intValue >> 8 & 0xFF));
            this.out.write((byte)(intValue & 0xFF));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)4, (Object)intValue);
        }
        return this;
    }

    @Override
    public ASN1Writer writeInteger(byte type, long longValue) throws IOException {
        this.out.write(type);
        if (longValue < 0L && (longValue & 0xFFFFFFFFFFFFFF80L) == -128L || (longValue & 0x7FL) == longValue) {
            this.writeLength(1);
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)1, (Object)longValue);
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFFFF8000L) == -32768L || (longValue & 0x7FFFL) == longValue) {
            this.writeLength(2);
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)2, (Object)longValue);
        } else if (longValue < 0L && (longValue & 0xFFFFFFFFFF800000L) == -8388608L || (longValue & 0x7FFFFFL) == longValue) {
            this.writeLength(3);
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)3, (Object)longValue);
        } else if (longValue < 0L && (longValue & Integer.MIN_VALUE) == Integer.MIN_VALUE || (longValue & Integer.MAX_VALUE) == longValue) {
            this.writeLength(4);
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)4, (Object)longValue);
        } else if (longValue < 0L && (longValue & 0xFFFFFF8000000000L) == -549755813888L || (longValue & 0x7FFFFFFFFFL) == longValue) {
            this.writeLength(5);
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)5, (Object)longValue);
        } else if (longValue < 0L && (longValue & 0xFFFF800000000000L) == -140737488355328L || (longValue & 0x7FFFFFFFFFFFL) == longValue) {
            this.writeLength(6);
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)6, (Object)longValue);
        } else if (longValue < 0L && (longValue & 0xFF80000000000000L) == -36028797018963968L || (longValue & 0x7FFFFFFFFFFFFFL) == longValue) {
            this.writeLength(7);
            this.out.write((byte)(longValue >> 48 & 0xFFL));
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)7, (Object)longValue);
        } else {
            this.writeLength(8);
            this.out.write((byte)(longValue >> 56 & 0xFFL));
            this.out.write((byte)(longValue >> 48 & 0xFFL));
            this.out.write((byte)(longValue >> 40 & 0xFFL));
            this.out.write((byte)(longValue >> 32 & 0xFFL));
            this.out.write((byte)(longValue >> 24 & 0xFFL));
            this.out.write((byte)(longValue >> 16 & 0xFFL));
            this.out.write((byte)(longValue >> 8 & 0xFFL));
            this.out.write((byte)(longValue & 0xFFL));
            logger.trace("WRITE ASN.1 INTEGER(type=0x%x, length=%d, value=%d)", (Object)type, (Object)8, (Object)longValue);
        }
        return this;
    }

    @Override
    public ASN1Writer writeNull(byte type) throws IOException {
        this.out.write(type);
        this.writeLength(0);
        logger.trace("WRITE ASN.1 NULL(type=0x%x, length=%d)", (Object)type, (Object)0);
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, byte[] value, int offset, int length) throws IOException {
        this.out.write(type);
        this.writeLength(length);
        this.out.write(value, offset, length);
        logger.trace("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)type, (Object)length);
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, ByteSequence value) throws IOException {
        this.out.write(type);
        this.writeLength(value.length());
        value.copyTo(this.out);
        logger.trace("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d)", (Object)type, (Object)value.length());
        return this;
    }

    @Override
    public ASN1Writer writeOctetString(byte type, String value) throws IOException {
        this.out.write(type);
        if (value == null) {
            this.writeLength(0);
            return this;
        }
        byte[] bytes = StaticUtils.getBytes(value);
        this.writeLength(bytes.length);
        this.out.write(bytes);
        logger.trace("WRITE ASN.1 OCTETSTRING(type=0x%x, length=%d, value=%s)", (Object)type, (Object)bytes.length, (Object)value);
        return this;
    }

    @Override
    public ASN1Writer writeStartSequence(byte type) throws IOException {
        this.out.write(type);
        ++this.stackDepth;
        if (this.stackDepth >= this.streamStack.size()) {
            ByteStringBuilder subStream = new ByteStringBuilder(32);
            this.streamStack.add(subStream);
            this.out = subStream.asOutputStream();
        } else {
            this.out = this.streamStack.get(this.stackDepth).asOutputStream();
        }
        logger.trace("WRITE ASN.1 START SEQUENCE(type=0x%x)", (Object)type);
        return this;
    }

    @Override
    public ASN1Writer writeStartSet(byte type) throws IOException {
        return this.writeStartSequence(type);
    }

    private void writeLength(int length) throws IOException {
        if (length < 128) {
            this.out.write((byte)length);
        } else if ((length & 0xFF) == length) {
            this.out.write(-127);
            this.out.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFF) == length) {
            this.out.write(-126);
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        } else if ((length & 0xFFFFFF) == length) {
            this.out.write(-125);
            this.out.write((byte)(length >> 16 & 0xFF));
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        } else {
            this.out.write(-124);
            this.out.write((byte)(length >> 24 & 0xFF));
            this.out.write((byte)(length >> 16 & 0xFF));
            this.out.write((byte)(length >> 8 & 0xFF));
            this.out.write((byte)(length & 0xFF));
        }
    }
}

