/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class AVA
implements Comparable<AVA> {
    private final AttributeType attributeType;
    private final ByteString attributeValue;
    private ByteString equalityNormalizedAttributeValue;
    private ByteString orderingNormalizedAttributeValue;

    public static AVA valueOf(String ava) {
        return AVA.valueOf(ava, Schema.getDefaultSchema());
    }

    public static AVA valueOf(String ava, Schema schema) {
        SubstringReader reader = new SubstringReader(ava);
        try {
            return AVA.decode(reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_RDN_TYPE_NOT_FOUND.get((Object)ava, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(message);
        }
    }

    static AVA decode(SubstringReader reader, Schema schema) {
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_NO_NAME.get((Object)reader.getString());
            throw new LocalizedIllegalArgumentException(message);
        }
        AttributeType attribute = AVA.readAttributeName(reader, schema);
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_END_WITH_ATTR_NAME.get((Object)reader.getString(), (Object)attribute.getNameOrOID());
            throw new LocalizedIllegalArgumentException(message);
        }
        char c = reader.read();
        if (c != '=') {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_NO_EQUAL.get((Object)reader.getString(), (Object)attribute.getNameOrOID(), (Object)Character.valueOf(c));
            throw new LocalizedIllegalArgumentException(message);
        }
        reader.skipWhitespaces();
        ByteString value = AVA.readAttributeValue(reader);
        return new AVA(attribute, (Object)value);
    }

    static void escapeAttributeValue(String str, StringBuilder builder) {
        if (str.length() > 0) {
            char c = str.charAt(0);
            int startPos = 0;
            if (c == ' ' || c == '#') {
                builder.append('\\');
                builder.append(c);
                startPos = 1;
            }
            int length = str.length();
            for (int si = startPos; si < length; ++si) {
                c = str.charAt(si);
                if (c < ' ') {
                    for (byte b : StaticUtils.getBytes(String.valueOf(c))) {
                        builder.append('\\');
                        builder.append(StaticUtils.byteToLowerHex(b));
                    }
                    continue;
                }
                if (c == ' ' && si == length - 1 || c == '\"' || c == '+' || c == ',' || c == ';' || c == '<' || c == '=' || c == '>' || c == '\\' || c == '\u0000') {
                    builder.append('\\');
                }
                builder.append(c);
            }
        }
    }

    private static void appendHexChars(SubstringReader reader, StringBuilder valueBuffer, StringBuilder hexBuffer) throws DecodeException {
        int length = hexBuffer.length();
        if (length == 0) {
            return;
        }
        if (length % 2 != 0) {
            LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_LENGTH.get((Object)hexBuffer);
            throw DecodeException.error(message);
        }
        int pos = 0;
        int arrayLength = length / 2;
        byte[] hexArray = new byte[arrayLength];
        block38: for (int i = 0; i < arrayLength; ++i) {
            switch (hexBuffer.charAt(pos++)) {
                case '0': {
                    hexArray[i] = 0;
                    break;
                }
                case '1': {
                    hexArray[i] = 16;
                    break;
                }
                case '2': {
                    hexArray[i] = 32;
                    break;
                }
                case '3': {
                    hexArray[i] = 48;
                    break;
                }
                case '4': {
                    hexArray[i] = 64;
                    break;
                }
                case '5': {
                    hexArray[i] = 80;
                    break;
                }
                case '6': {
                    hexArray[i] = 96;
                    break;
                }
                case '7': {
                    hexArray[i] = 112;
                    break;
                }
                case '8': {
                    hexArray[i] = -128;
                    break;
                }
                case '9': {
                    hexArray[i] = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    hexArray[i] = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    hexArray[i] = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    hexArray[i] = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    hexArray[i] = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    hexArray[i] = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    hexArray[i] = -16;
                    break;
                }
                default: {
                    LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get((Object)hexBuffer, (Object)Character.valueOf(hexBuffer.charAt(pos - 1)));
                    throw DecodeException.error(message);
                }
            }
            switch (hexBuffer.charAt(pos++)) {
                case '0': {
                    continue block38;
                }
                case '1': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 1);
                    continue block38;
                }
                case '2': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 2);
                    continue block38;
                }
                case '3': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 3);
                    continue block38;
                }
                case '4': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 4);
                    continue block38;
                }
                case '5': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 5);
                    continue block38;
                }
                case '6': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 6);
                    continue block38;
                }
                case '7': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 7);
                    continue block38;
                }
                case '8': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 8);
                    continue block38;
                }
                case '9': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 9);
                    continue block38;
                }
                case 'A': 
                case 'a': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 0xA);
                    continue block38;
                }
                case 'B': 
                case 'b': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 0xB);
                    continue block38;
                }
                case 'C': 
                case 'c': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 0xC);
                    continue block38;
                }
                case 'D': 
                case 'd': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 0xD);
                    continue block38;
                }
                case 'E': 
                case 'e': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 0xE);
                    continue block38;
                }
                case 'F': 
                case 'f': {
                    int n = i;
                    hexArray[n] = (byte)(hexArray[n] | 0xF);
                    continue block38;
                }
                default: {
                    LocalizableMessage message = CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get((Object)hexBuffer, (Object)Character.valueOf(hexBuffer.charAt(pos - 1)));
                    throw DecodeException.error(message);
                }
            }
        }
        try {
            valueBuffer.append(new String(hexArray, "UTF-8"));
        }
        catch (Exception e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get((Object)reader.getString(), (Object)String.valueOf(e));
            throw DecodeException.error(message);
        }
        hexBuffer.setLength(0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ByteString delimitAndEvaluateEscape(SubstringReader reader) throws DecodeException {
        char c = '\u0000';
        StringBuilder valueBuffer = new StringBuilder();
        StringBuilder hexBuffer = new StringBuilder();
        reader.skipWhitespaces();
        boolean escaped = false;
        while (true) {
            if (reader.remaining() <= 0) {
                reader.reset();
                return ByteString.valueOfUtf8(valueBuffer);
            }
            c = reader.read();
            if (escaped) {
                if (StaticUtils.isHexDigit(c)) {
                    if (reader.remaining() <= 0) {
                        LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID.get((Object)reader.getString());
                        throw DecodeException.error(msg);
                    }
                    char c2 = reader.read();
                    if (!StaticUtils.isHexDigit(c2)) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ESCAPED_HEX_VALUE_INVALID.get((Object)reader.getString());
                        throw DecodeException.error(message);
                    }
                    hexBuffer.append(c);
                    hexBuffer.append(c2);
                    if (reader.remaining() == 0) {
                        AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    }
                } else {
                    AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    valueBuffer.append(c);
                }
                escaped = false;
            } else if (c == '\\') {
                escaped = true;
            } else {
                if (c == '+' || c == ',' || c == ';') {
                    reader.reset();
                    AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                    return ByteString.valueOfUtf8(valueBuffer);
                }
                AVA.appendHexChars(reader, valueBuffer, hexBuffer);
                valueBuffer.append(c);
            }
            reader.mark();
        }
    }

    private static AttributeType readAttributeName(SubstringReader reader, Schema schema) {
        int length = 1;
        reader.mark();
        char c = reader.read();
        if (StaticUtils.isDigit(c)) {
            boolean lastWasPeriod = false;
            while (reader.remaining() > 0 && (c = reader.read()) != '=' && c != ' ') {
                if (c == '.') {
                    if (lastWasPeriod) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get((Object)reader.getString(), (Object)Character.valueOf(c), (Object)(reader.pos() - 1));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                    lastWasPeriod = true;
                } else {
                    if (!StaticUtils.isDigit(c)) {
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get((Object)reader.getString(), (Object)Character.valueOf(c), (Object)(reader.pos() - 1));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                    lastWasPeriod = false;
                }
                ++length;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (reader.remaining() > 0 && (c = reader.read()) != '=' && c != ' ') {
                if (!StaticUtils.isAlpha(c) && !StaticUtils.isDigit(c) && c != '-') {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get((Object)reader.getString(), (Object)Character.valueOf(c), (Object)(reader.pos() - 1));
                    throw new LocalizedIllegalArgumentException(message);
                }
                ++length;
            }
        } else {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_ILLEGAL_CHAR.get((Object)reader.getString(), (Object)Character.valueOf(c), (Object)(reader.pos() - 1));
            throw new LocalizedIllegalArgumentException(message);
        }
        reader.reset();
        return schema.getAttributeType(reader.read(length));
    }

    private static ByteString readAttributeValue(SubstringReader reader) {
        ByteString bytes;
        if (reader.remaining() == 0) {
            return ByteString.empty();
        }
        reader.mark();
        char c = reader.read();
        int length = 0;
        if (c == '+') {
            reader.reset();
            return ByteString.empty();
        }
        if (c == '#') {
            reader.mark();
            if (reader.remaining() < 2) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get((Object)reader.getString());
                throw new LocalizedIllegalArgumentException(message);
            }
            for (int i = 0; i < 2; ++i) {
                c = reader.read();
                if (StaticUtils.isHexDigit(c)) {
                    ++length;
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get((Object)reader.getString(), (Object)Character.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            while (reader.remaining() > 0) {
                c = reader.read();
                if (StaticUtils.isHexDigit(c)) {
                    ++length;
                    if (reader.remaining() > 0) {
                        c = reader.read();
                        if (StaticUtils.isHexDigit(c)) {
                            ++length;
                            continue;
                        }
                        LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get((Object)reader.getString(), (Object)Character.valueOf(c));
                        throw new LocalizedIllegalArgumentException(message);
                    }
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_HEX_VALUE_TOO_SHORT.get((Object)reader.getString());
                    throw new LocalizedIllegalArgumentException(message);
                }
                if (c == ' ' || c == ',' || c == ';') break;
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_HEX_DIGIT.get((Object)reader.getString(), (Object)Character.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            try {
                reader.reset();
                return ByteString.valueOfHex(reader.read(length));
            }
            catch (LocalizedIllegalArgumentException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_ATTR_VALUE_DECODE_FAILURE.get((Object)reader.getString(), (Object)e.getMessageObject());
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        if (c == '\"') {
            reader.mark();
            while (true) {
                if (reader.remaining() <= 0) {
                    LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_UNMATCHED_QUOTE.get((Object)reader.getString());
                    throw new LocalizedIllegalArgumentException(message);
                }
                if (reader.read() == '\"') break;
                ++length;
            }
            reader.reset();
            ByteString retString = ByteString.valueOfUtf8(reader.read(length));
            reader.read();
            return retString;
        }
        reader.reset();
        try {
            bytes = AVA.delimitAndEvaluateEscape(reader);
        }
        catch (DecodeException e) {
            throw new LocalizedIllegalArgumentException(e.getMessageObject());
        }
        if (bytes.length() == 0) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DN_INVALID_REQUIRES_ESCAPE_CHAR.get((Object)reader.getString(), (Object)reader.pos());
            throw new LocalizedIllegalArgumentException(message);
        }
        return bytes;
    }

    public AVA(AttributeType attributeType, Object attributeValue) {
        Reject.ifNull((Object[])new Object[]{attributeType, attributeValue});
        this.attributeType = attributeType;
        this.attributeValue = ByteString.valueOfObject(attributeValue);
    }

    public AVA(String attributeType, Object attributeValue) {
        Reject.ifNull((Object[])new Object[]{attributeType, attributeValue});
        this.attributeType = Schema.getDefaultSchema().getAttributeType(attributeType);
        this.attributeValue = ByteString.valueOfObject(attributeValue);
    }

    @Override
    public int compareTo(AVA ava) {
        int result = this.attributeType.compareTo(ava.attributeType);
        if (result != 0) {
            return result > 0 ? 1 : -1;
        }
        ByteString normalizedValue = this.getOrderingNormalizedValue();
        ByteString otherNormalizedValue = ava.getOrderingNormalizedValue();
        return normalizedValue.compareTo(otherNormalizedValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AVA) {
            AVA ava = (AVA)obj;
            if (!this.attributeType.equals(ava.attributeType)) {
                return false;
            }
            ByteString normalizedValue = this.getEqualityNormalizedValue();
            ByteString otherNormalizedValue = ava.getEqualityNormalizedValue();
            return normalizedValue.equals(otherNormalizedValue);
        }
        return false;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public ByteString getAttributeValue() {
        return this.attributeValue;
    }

    public int hashCode() {
        return this.attributeType.hashCode() * 31 + this.getEqualityNormalizedValue().hashCode();
    }

    public Attribute toAttribute() {
        AttributeDescription ad = AttributeDescription.create(this.attributeType);
        return new LinkedAttribute(ad, (Object)this.attributeValue);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        return this.toString(builder).toString();
    }

    StringBuilder toString(StringBuilder builder) {
        if (!this.attributeType.getNames().iterator().hasNext()) {
            builder.append(this.attributeType.getOID());
            builder.append("=#");
            builder.append(this.attributeValue.toHexString());
        } else {
            String name = this.attributeType.getNameOrOID();
            builder.append(name);
            builder.append("=");
            Syntax syntax = this.attributeType.getSyntax();
            if (!syntax.isHumanReadable()) {
                builder.append("#");
                builder.append(this.attributeValue.toHexString());
            } else {
                AVA.escapeAttributeValue(this.attributeValue.toString(), builder);
            }
        }
        return builder;
    }

    private ByteString getEqualityNormalizedValue() {
        ByteString normalizedValue = this.equalityNormalizedAttributeValue;
        if (normalizedValue != null) {
            return normalizedValue;
        }
        MatchingRule matchingRule = this.attributeType.getEqualityMatchingRule();
        if (matchingRule != null) {
            try {
                this.equalityNormalizedAttributeValue = matchingRule.normalizeAttributeValue(this.attributeValue);
            }
            catch (DecodeException de) {
                this.equalityNormalizedAttributeValue = this.attributeValue;
            }
        } else {
            this.equalityNormalizedAttributeValue = this.attributeValue;
        }
        return this.equalityNormalizedAttributeValue;
    }

    private ByteString getOrderingNormalizedValue() {
        ByteString normalizedValue = this.orderingNormalizedAttributeValue;
        if (normalizedValue != null) {
            return normalizedValue;
        }
        MatchingRule matchingRule = this.attributeType.getEqualityMatchingRule();
        if (matchingRule != null) {
            try {
                this.orderingNormalizedAttributeValue = matchingRule.normalizeAttributeValue(this.attributeValue);
            }
            catch (DecodeException de) {
                this.orderingNormalizedAttributeValue = this.getEqualityNormalizedValue();
            }
        } else {
            this.orderingNormalizedAttributeValue = this.getEqualityNormalizedValue();
        }
        return this.orderingNormalizedAttributeValue;
    }

    ByteStringBuilder toNormalizedByteString(ByteStringBuilder builder) {
        builder.appendUtf8(StaticUtils.toLowerCase(this.attributeType.getNameOrOID()));
        builder.appendUtf8("=");
        ByteString value = this.getEqualityNormalizedValue();
        if (value.length() > 0) {
            builder.appendBytes(this.escapeBytes(value));
        }
        return builder;
    }

    StringBuilder toNormalizedUrlSafe(StringBuilder builder) {
        builder.append(StaticUtils.toLowerCase(this.attributeType.getNameOrOID()));
        builder.append('=');
        ByteString value = this.getEqualityNormalizedValue();
        if (value.length() == 0) {
            return builder;
        }
        boolean hasAttributeName = !this.attributeType.getNames().isEmpty();
        boolean isHumanReadable = this.attributeType.getSyntax().isHumanReadable();
        if (!hasAttributeName || !isHumanReadable) {
            builder.append(value.toPercentHexString());
        } else {
            CharsetDecoder decoder;
            CharBuffer buffer = CharBuffer.allocate(value.length());
            if (value.copyTo(buffer, decoder = Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT))) {
                buffer.flip();
                try {
                    String val = URLEncoder.encode(buffer.toString(), "UTF-8").replaceAll("\\+", "%20");
                    builder.append(val);
                }
                catch (UnsupportedEncodingException e) {
                    builder.append(value.toPercentHexString());
                }
            } else {
                builder.append(value.toPercentHexString());
            }
        }
        return builder;
    }

    private ByteString escapeBytes(ByteString value) {
        if (!this.needEscaping(value)) {
            return value;
        }
        ByteStringBuilder builder = new ByteStringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if (this.isByteToEscape(b)) {
                builder.appendByte(2);
            }
            builder.appendByte(b);
        }
        return builder.toByteString();
    }

    private boolean needEscaping(ByteString value) {
        boolean needEscaping = false;
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if (!this.isByteToEscape(b)) continue;
            needEscaping = true;
            break;
        }
        return needEscaping;
    }

    private boolean isByteToEscape(byte b) {
        return b == 0 || b == 1 || b == 2;
    }
}

