/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Option;
import org.forgerock.util.Options;

abstract class CommonLDAPOptions {
    public static final Option<ClassLoader> TRANSPORT_PROVIDER_CLASS_LOADER = Option.of(ClassLoader.class, null);
    public static final Option<String> TRANSPORT_PROVIDER = Option.of(String.class, null);
    static final Option<TransportProvider> TRANSPORT_PROVIDER_INSTANCE = Option.of(TransportProvider.class, null);
    public static final Option<Boolean> TCP_NO_DELAY = Option.withDefault((Object)CommonLDAPOptions.getBooleanProperty("org.forgerock.opendj.io.tcpNoDelay", true));
    public static final Option<Boolean> SO_REUSE_ADDRESS = Option.withDefault((Object)CommonLDAPOptions.getBooleanProperty("org.forgerock.opendj.io.reuseAddress", true));
    public static final Option<Integer> SO_LINGER_IN_SECONDS = Option.withDefault((Object)CommonLDAPOptions.getIntProperty("org.forgerock.opendj.io.linger", -1));
    public static final Option<Boolean> SO_KEEPALIVE = Option.withDefault((Object)CommonLDAPOptions.getBooleanProperty("org.forgerock.opendj.io.keepAlive", true));
    public static final Option<DecodeOptions> LDAP_DECODE_OPTIONS = Option.withDefault((Object)new DecodeOptions());

    CommonLDAPOptions() {
    }

    static TransportProvider getTransportProvider(Options options) {
        TransportProvider transportProvider = (TransportProvider)options.get(TRANSPORT_PROVIDER_INSTANCE);
        if (transportProvider != null) {
            return transportProvider;
        }
        return StaticUtils.getProvider(TransportProvider.class, (String)options.get(TRANSPORT_PROVIDER), (ClassLoader)options.get(TRANSPORT_PROVIDER_CLASS_LOADER));
    }

    static boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    static int getIntProperty(String name, int defaultValue) {
        String value = System.getProperty(name);
        try {
            return value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

