/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.forgerock.opendj.ldap.AbstractConnectionWrapper;
import org.forgerock.opendj.ldap.CachedConnectionPool;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.FailoverLoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.InternalConnection;
import org.forgerock.opendj.ldap.InternalConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancer;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.RequestHandlerFactoryAdapter;
import org.forgerock.opendj.ldap.RoundRobinLoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

public final class Connections {
    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory) {
        return new CachedConnectionPool(factory, 0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, null);
    }

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit) {
        return new CachedConnectionPool(factory, corePoolSize, maximumPoolSize, idleTimeout, unit, null);
    }

    public static ConnectionPool newCachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit, ScheduledExecutorService scheduler) {
        return new CachedConnectionPool(factory, corePoolSize, maximumPoolSize, idleTimeout, unit, scheduler);
    }

    public static ConnectionPool newFixedConnectionPool(ConnectionFactory factory, int poolSize) {
        return new CachedConnectionPool(factory, poolSize, poolSize, 0L, null, null);
    }

    public static Connection newInternalConnection(RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return Connections.newInternalConnection(RequestHandlerFactoryAdapter.adaptRequestHandler(requestHandler));
    }

    public static Connection newInternalConnection(ServerConnection<Integer> serverConnection) {
        Reject.ifNull(serverConnection);
        return new InternalConnection(serverConnection);
    }

    public static ConnectionFactory newInternalConnectionFactory(RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return new InternalConnectionFactory<Object>(Connections.newServerConnectionFactory(requestHandler), null);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(RequestHandlerFactory<C, RequestContext> factory, C clientContext) {
        Reject.ifNull(factory);
        return new InternalConnectionFactory<C>(Connections.newServerConnectionFactory(factory), clientContext);
    }

    public static <C> ConnectionFactory newInternalConnectionFactory(ServerConnectionFactory<C, Integer> factory, C clientContext) {
        Reject.ifNull(factory);
        return new InternalConnectionFactory<C>(factory, clientContext);
    }

    public static ConnectionFactory newRoundRobinLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        return new LoadBalancer(new RoundRobinLoadBalancingAlgorithm(factories, options));
    }

    public static ConnectionFactory newFailoverLoadBalancer(Collection<? extends ConnectionFactory> factories, Options options) {
        return new LoadBalancer(new FailoverLoadBalancingAlgorithm(factories, options));
    }

    public static ConnectionFactory newLoadBalancer(LoadBalancingAlgorithm algorithm) {
        return new LoadBalancer(algorithm);
    }

    public static ConnectionFactory newNamedConnectionFactory(final ConnectionFactory factory, final String name) {
        Reject.ifNull((Object)factory, (String)name);
        return new ConnectionFactory(){

            @Override
            public void close() {
                factory.close();
            }

            @Override
            public Connection getConnection() throws LdapException {
                return factory.getConnection();
            }

            @Override
            public Promise<Connection, LdapException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            public String toString() {
                return name;
            }
        };
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(final RequestHandler<RequestContext> requestHandler) {
        Reject.ifNull(requestHandler);
        return new RequestHandlerFactoryAdapter(new RequestHandlerFactory<C, RequestContext>(){

            @Override
            public RequestHandler<RequestContext> handleAccept(C clientContext) {
                return requestHandler;
            }
        });
    }

    public static <C> ServerConnectionFactory<C, Integer> newServerConnectionFactory(RequestHandlerFactory<C, RequestContext> factory) {
        Reject.ifNull(factory);
        return new RequestHandlerFactoryAdapter<C>(factory);
    }

    public static Connection uncloseable(Connection connection) {
        return new AbstractConnectionWrapper<Connection>(connection){

            @Override
            public void close() {
            }

            @Override
            public void close(UnbindRequest request, String reason) {
            }
        };
    }

    public static ConnectionFactory uncloseable(final ConnectionFactory factory) {
        return new ConnectionFactory(){

            @Override
            public Promise<Connection, LdapException> getConnectionAsync() {
                return factory.getConnectionAsync();
            }

            @Override
            public Connection getConnection() throws LdapException {
                return factory.getConnection();
            }

            @Override
            public void close() {
            }
        };
    }

    public static String getHostString(InetSocketAddress socketAddress) {
        if (socketAddress.isUnresolved()) {
            return socketAddress.getHostName();
        }
        InetAddress address = socketAddress.getAddress();
        String hostSlashIp = address.toString();
        int slashPos = hostSlashIp.indexOf(47);
        if (slashPos == 0) {
            return hostSlashIp.substring(1);
        }
        return hostSlashIp.substring(0, slashPos);
    }

    private Connections() {
    }
}

