/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.spi.BindResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.ExtendedResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.opendj.ldap.spi.ResultLdapPromiseImpl;
import org.forgerock.opendj.ldap.spi.SearchResultLdapPromiseImpl;
import org.forgerock.util.Reject;

final class InternalConnection
extends AbstractAsynchronousConnection {
    private final ServerConnection<Integer> serverConnection;
    private final List<ConnectionEventListener> listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final AtomicInteger messageID = new AtomicInteger();

    InternalConnection(ServerConnection<Integer> serverConnection) {
        this.serverConnection = serverConnection;
    }

    @Override
    public LdapPromise<Void> abandonAsync(AbandonRequest request) {
        int i = this.messageID.getAndIncrement();
        this.serverConnection.handleAbandon(i, request);
        return LdapPromises.newSuccessfulLdapPromise(null, i);
    }

    @Override
    public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        ResultLdapPromiseImpl<AddRequest, Result> promise = LdapPromises.newResultLdapPromise(i, request, intermediateResponseHandler, this);
        this.serverConnection.handleAdd(i, request, promise, promise);
        return promise;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        Reject.ifNull((Object)listener);
        this.listeners.add(listener);
    }

    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        BindResultLdapPromiseImpl promise = LdapPromises.newBindLdapPromise(i, request, null, intermediateResponseHandler, this);
        this.serverConnection.handleBind(i, 3, request, promise, promise);
        return promise;
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        int i = this.messageID.getAndIncrement();
        this.serverConnection.handleConnectionClosed(i, request);
    }

    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        ResultLdapPromiseImpl<CompareRequest, CompareResult> promise = LdapPromises.newCompareLdapPromise(i, request, intermediateResponseHandler, this);
        this.serverConnection.handleCompare(i, request, promise, promise);
        return promise;
    }

    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        ResultLdapPromiseImpl<DeleteRequest, Result> promise = LdapPromises.newResultLdapPromise(i, request, intermediateResponseHandler, this);
        this.serverConnection.handleDelete(i, request, promise, promise);
        return promise;
    }

    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        ExtendedResultLdapPromiseImpl<R> promise = LdapPromises.newExtendedLdapPromise(i, request, intermediateResponseHandler, this);
        this.serverConnection.handleExtendedRequest(i, request, promise, promise);
        return promise;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        ResultLdapPromiseImpl<ModifyRequest, Result> promise = LdapPromises.newResultLdapPromise(i, request, intermediateResponseHandler, this);
        this.serverConnection.handleModify(i, request, promise, promise);
        return promise;
    }

    @Override
    public LdapPromise<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        int i = this.messageID.getAndIncrement();
        ResultLdapPromiseImpl<ModifyDNRequest, Result> promise = LdapPromises.newResultLdapPromise(i, request, intermediateResponseHandler, this);
        this.serverConnection.handleModifyDN(i, request, promise, promise);
        return promise;
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        Reject.ifNull((Object)listener);
        this.listeners.remove(listener);
    }

    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
        int i = this.messageID.getAndIncrement();
        SearchResultLdapPromiseImpl promise = LdapPromises.newSearchLdapPromise(i, request, entryHandler, intermediateResponseHandler, this);
        this.serverConnection.handleSearch(i, request, promise, promise, promise);
        return promise;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InternalConnection(");
        builder.append(this.serverConnection);
        builder.append(')');
        return builder.toString();
    }
}

