/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.InternalConnection;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class InternalConnectionFactory<C>
implements ConnectionFactory {
    private final ServerConnectionFactory<C, Integer> factory;
    private final C clientContext;

    InternalConnectionFactory(ServerConnectionFactory<C, Integer> factory, C clientContext) {
        this.factory = factory;
        this.clientContext = clientContext;
    }

    @Override
    public void close() {
    }

    @Override
    public Connection getConnection() throws LdapException {
        ServerConnection<Integer> serverConnection = this.factory.handleAccept(this.clientContext);
        return new InternalConnection(serverConnection);
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        ServerConnection<Integer> serverConnection;
        try {
            serverConnection = this.factory.handleAccept(this.clientContext);
        }
        catch (LdapException e) {
            return LdapPromises.newFailedLdapPromise(e);
        }
        return Promises.newResultPromise((Object)new InternalConnection(serverConnection));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InternalConnectionFactory(");
        builder.append(this.clientContext);
        builder.append(',');
        builder.append(this.factory);
        builder.append(')');
        return builder.toString();
    }
}

