/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.IOException;
import org.forgerock.opendj.ldap.AssertionFailureException;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConstraintViolationException;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ReferralException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;

public class LdapException
extends IOException {
    private final Result result;

    public static LdapException newLdapException(ResultCode resultCode) {
        return LdapException.newLdapException(resultCode, null, null);
    }

    public static LdapException newLdapException(ResultCode resultCode, CharSequence diagnosticMessage) {
        return LdapException.newLdapException(resultCode, diagnosticMessage, null);
    }

    public static LdapException newLdapException(ResultCode resultCode, Throwable cause) {
        return LdapException.newLdapException(resultCode, null, cause);
    }

    public static LdapException newLdapException(ResultCode resultCode, CharSequence diagnosticMessage, Throwable cause) {
        Result result = Responses.newResult(resultCode);
        if (diagnosticMessage != null) {
            result.setDiagnosticMessage(diagnosticMessage.toString());
        } else if (cause != null) {
            result.setDiagnosticMessage(cause.getLocalizedMessage());
        }
        result.setCause(cause);
        return LdapException.newLdapException(result);
    }

    public static LdapException newLdapException(Result result) {
        if (!result.getResultCode().isExceptional()) {
            throw new IllegalArgumentException("Attempted to wrap a successful result: " + result);
        }
        switch (result.getResultCode().asEnum()) {
            case ASSERTION_FAILED: {
                return new AssertionFailureException(result);
            }
            case AUTH_METHOD_NOT_SUPPORTED: 
            case CLIENT_SIDE_AUTH_UNKNOWN: 
            case INAPPROPRIATE_AUTHENTICATION: 
            case INVALID_CREDENTIALS: {
                return new AuthenticationException(result);
            }
            case AUTHORIZATION_DENIED: 
            case CONFIDENTIALITY_REQUIRED: 
            case INSUFFICIENT_ACCESS_RIGHTS: 
            case STRONG_AUTH_REQUIRED: {
                return new AuthorizationException(result);
            }
            case CLIENT_SIDE_USER_CANCELLED: 
            case CANCELLED: {
                return new CancelledResultException(result);
            }
            case CLIENT_SIDE_SERVER_DOWN: 
            case CLIENT_SIDE_CONNECT_ERROR: 
            case CLIENT_SIDE_DECODING_ERROR: 
            case CLIENT_SIDE_ENCODING_ERROR: {
                return new ConnectionException(result);
            }
            case ATTRIBUTE_OR_VALUE_EXISTS: 
            case NO_SUCH_ATTRIBUTE: 
            case CONSTRAINT_VIOLATION: 
            case ENTRY_ALREADY_EXISTS: 
            case INVALID_ATTRIBUTE_SYNTAX: 
            case INVALID_DN_SYNTAX: 
            case NAMING_VIOLATION: 
            case NOT_ALLOWED_ON_NONLEAF: 
            case NOT_ALLOWED_ON_RDN: 
            case OBJECTCLASS_MODS_PROHIBITED: 
            case OBJECTCLASS_VIOLATION: 
            case UNDEFINED_ATTRIBUTE_TYPE: {
                return new ConstraintViolationException(result);
            }
            case REFERRAL: {
                return new ReferralException(result);
            }
            case NO_SUCH_OBJECT: 
            case CLIENT_SIDE_NO_RESULTS_RETURNED: {
                return new EntryNotFoundException(result);
            }
            case CLIENT_SIDE_UNEXPECTED_RESULTS_RETURNED: {
                return new MultipleEntriesFoundException(result);
            }
            case CLIENT_SIDE_TIMEOUT: 
            case TIME_LIMIT_EXCEEDED: {
                return new TimeoutResultException(result);
            }
        }
        return new LdapException(result);
    }

    private static String getMessage(Result result) {
        if (result.getDiagnosticMessage() == null || result.getDiagnosticMessage().isEmpty()) {
            return result.getResultCode().toString();
        }
        return result.getResultCode() + ": " + result.getDiagnosticMessage();
    }

    protected LdapException(Result result) {
        super(LdapException.getMessage(result), result.getCause());
        this.result = result;
    }

    public final Result getResult() {
        return this.result;
    }
}

