/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class LoadBalancer
implements ConnectionFactory {
    private final LoadBalancingAlgorithm algorithm;

    LoadBalancer(LoadBalancingAlgorithm algorithm) {
        Reject.ifNull((Object)algorithm);
        this.algorithm = algorithm;
    }

    @Override
    public void close() {
        this.algorithm.close();
    }

    @Override
    public Connection getConnection() throws LdapException {
        return this.algorithm.getConnectionFactory().getConnection();
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        ConnectionFactory factory;
        try {
            factory = this.algorithm.getConnectionFactory();
        }
        catch (LdapException e) {
            return Promises.newExceptionPromise((Exception)e);
        }
        return factory.getConnectionAsync();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LoadBalancer(");
        builder.append(this.algorithm);
        builder.append(')');
        return builder.toString();
    }
}

