/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.EventListener;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;

public interface LoadBalancerEventListener
extends EventListener {
    public static final LoadBalancerEventListener LOG_EVENTS = new LoadBalancerEventListener(){
        private final LocalizedLogger logger = LocalizedLogger.getLocalizedLogger(LoadBalancingAlgorithm.class);

        @Override
        public void handleConnectionFactoryOnline(ConnectionFactory factory) {
            this.logger.info(CoreMessages.LOAD_BALANCER_EVENT_LISTENER_LOG_ONLINE.get((Object)factory));
        }

        @Override
        public void handleConnectionFactoryOffline(ConnectionFactory factory, LdapException error) {
            this.logger.warn(CoreMessages.LOAD_BALANCER_EVENT_LISTENER_LOG_OFFLINE.get((Object)factory, (Object)error.getMessage()));
        }
    };
    public static final LoadBalancerEventListener NO_OP = new LoadBalancerEventListener(){

        @Override
        public void handleConnectionFactoryOnline(ConnectionFactory factory) {
        }

        @Override
        public void handleConnectionFactoryOffline(ConnectionFactory factory, LdapException error) {
        }
    };

    public void handleConnectionFactoryOffline(ConnectionFactory var1, LdapException var2);

    public void handleConnectionFactoryOnline(ConnectionFactory var1);
}

