/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CancelRequestListener;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapResultHandler;
import org.forgerock.opendj.ldap.RequestContext;
import org.forgerock.opendj.ldap.RequestHandler;
import org.forgerock.opendj.ldap.RequestHandlerFactory;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.util.Reject;

final class RequestHandlerFactoryAdapter<C>
implements ServerConnectionFactory<C, Integer> {
    private final RequestHandlerFactory<C, RequestContext> factory;

    static ServerConnection<Integer> adaptRequestHandler(RequestHandler<RequestContext> requestHandler) {
        return new ServerConnectionImpl(requestHandler);
    }

    RequestHandlerFactoryAdapter(RequestHandlerFactory<C, RequestContext> factory) {
        this.factory = factory;
    }

    @Override
    public ServerConnection<Integer> handleAccept(C clientContext) throws LdapException {
        return RequestHandlerFactoryAdapter.adaptRequestHandler(this.factory.handleAccept(clientContext));
    }

    private static final class ServerConnectionImpl
    implements ServerConnection<Integer> {
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private final ConcurrentHashMap<Integer, RequestContextImpl<?, ?>> pendingRequests = new ConcurrentHashMap();
        private final RequestHandler<RequestContext> requestHandler;

        private ServerConnectionImpl(RequestHandler<RequestContext> requestHandler) {
            this.requestHandler = requestHandler;
        }

        @Override
        public void handleAbandon(Integer messageID, AbandonRequest request) {
            RequestContextImpl<?, ?> abandonedRequest = this.getPendingRequest(request.getRequestID());
            if (abandonedRequest != null) {
                LocalizableMessage abandonReason = CoreMessages.INFO_CANCELED_BY_ABANDON_REQUEST.get((Object)messageID);
                ((RequestContextImpl)abandonedRequest).cancel(abandonReason, null, null, false);
            }
        }

        @Override
        public void handleAdd(Integer messageID, AddRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, true);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleAdd(requestContext, request, intermediateResponseHandler, requestContext);
            }
        }

        @Override
        public void handleBind(Integer messageID, int version, BindRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<BindResult> resultHandler) {
            RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, false);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleBind(requestContext, version, request, intermediateResponseHandler, requestContext);
            }
        }

        @Override
        public void handleCompare(Integer messageID, CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<CompareResult> resultHandler) {
            RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, true);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleCompare(requestContext, request, intermediateResponseHandler, requestContext);
            }
        }

        @Override
        public void handleConnectionClosed(Integer messageID, UnbindRequest request) {
            LocalizableMessage cancelReason = CoreMessages.INFO_CANCELED_BY_CLIENT_DISCONNECT.get();
            this.doClose(cancelReason);
        }

        @Override
        public void handleConnectionDisconnected(ResultCode resultCode, String message) {
            LocalizableMessage cancelReason = CoreMessages.INFO_CANCELED_BY_SERVER_DISCONNECT.get();
            this.doClose(cancelReason);
        }

        @Override
        public void handleConnectionError(Throwable error) {
            LocalizableMessage cancelReason = CoreMessages.INFO_CANCELED_BY_CLIENT_ERROR.get();
            this.doClose(cancelReason);
        }

        @Override
        public void handleDelete(Integer messageID, DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, true);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleDelete(requestContext, request, intermediateResponseHandler, requestContext);
            }
        }

        @Override
        public <R extends ExtendedResult> void handleExtendedRequest(Integer messageID, ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<R> resultHandler) {
            if (request.getOID().equals("1.3.6.1.1.8")) {
                CancelExtendedRequest cancelRequest;
                try {
                    cancelRequest = CancelExtendedRequest.DECODER.decodeExtendedRequest(request, new DecodeOptions());
                }
                catch (DecodeException e) {
                    resultHandler.handleException(LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e.getLocalizedMessage()));
                    return;
                }
                RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, false);
                if (this.addPendingRequest(requestContext)) {
                    RequestContextImpl<?, ?> cancelledRequest = this.getPendingRequest(cancelRequest.getRequestID());
                    if (cancelledRequest != null) {
                        LocalizableMessage cancelReason = CoreMessages.INFO_CANCELED_BY_CANCEL_REQUEST.get((Object)messageID);
                        ((RequestContextImpl)cancelledRequest).cancel(cancelReason, request, requestContext, true);
                    } else {
                        requestContext.handleException(LdapException.newLdapException(ResultCode.NO_SUCH_OPERATION));
                    }
                }
            } else {
                boolean isCancelSupported = !request.getOID().equals("1.3.6.1.4.1.1466.20037");
                RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, isCancelSupported);
                if (this.addPendingRequest(requestContext)) {
                    this.requestHandler.handleExtendedRequest(requestContext, request, intermediateResponseHandler, requestContext);
                }
            }
        }

        @Override
        public void handleModify(Integer messageID, ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, true);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleModify(requestContext, request, intermediateResponseHandler, requestContext);
            }
        }

        @Override
        public void handleModifyDN(Integer messageID, ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, LdapResultHandler<Result> resultHandler) {
            RequestContextImpl requestContext = new RequestContextImpl(this, resultHandler, messageID, true);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleModifyDN(requestContext, request, intermediateResponseHandler, requestContext);
            }
        }

        @Override
        public void handleSearch(Integer messageID, SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler) {
            SearchRequestContextImpl requestContext = new SearchRequestContextImpl(this, entryHandler, resultHandler, messageID, true);
            if (this.addPendingRequest(requestContext)) {
                this.requestHandler.handleSearch(requestContext, request, intermediateResponseHandler, entryHandler, requestContext);
            }
        }

        private boolean addPendingRequest(RequestContextImpl<?, ?> requestContext) {
            Integer messageID = requestContext.getMessageID();
            if (this.isClosed.get()) {
                LocalizableMessage message = CoreMessages.INFO_CLIENT_CONNECTION_CLOSING.get();
                requestContext.handleException(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, message.toString()));
                return false;
            }
            if (this.pendingRequests.putIfAbsent(messageID, requestContext) != null) {
                LocalizableMessage message = CoreMessages.WARN_CLIENT_DUPLICATE_MESSAGE_ID.get((Object)requestContext.getMessageID());
                requestContext.handleException(LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, message.toString()));
                return false;
            }
            if (this.isClosed.get()) {
                this.pendingRequests.remove(messageID);
                LocalizableMessage message = CoreMessages.INFO_CLIENT_CONNECTION_CLOSING.get();
                requestContext.handleException(LdapException.newLdapException(ResultCode.UNWILLING_TO_PERFORM, message.toString()));
                return false;
            }
            return true;
        }

        private void doClose(LocalizableMessage cancelReason) {
            if (!this.isClosed.getAndSet(true)) {
                Iterator<RequestContextImpl<?, ?>> iterator = this.pendingRequests.values().iterator();
                while (iterator.hasNext()) {
                    RequestContextImpl<?, ?> pendingRequest = iterator.next();
                    ((RequestContextImpl)pendingRequest).cancel(cancelReason, null, null, false);
                    iterator.remove();
                }
            }
        }

        private RequestContextImpl<?, ?> getPendingRequest(Integer messageID) {
            return this.pendingRequests.get(messageID);
        }

        private boolean removePendingRequest(RequestContextImpl<?, ?> requestContext) {
            return this.pendingRequests.remove(requestContext.getMessageID()) != null;
        }
    }

    private static final class SearchRequestContextImpl
    extends RequestContextImpl<Result, LdapResultHandler<Result>>
    implements SearchResultHandler {
        private final SearchResultHandler entryHandler;

        private SearchRequestContextImpl(ServerConnectionImpl clientConnection, SearchResultHandler entryHandler, LdapResultHandler<Result> resultHandler, int messageID, boolean isCancelSupported) {
            super(clientConnection, resultHandler, messageID, isCancelSupported);
            this.entryHandler = entryHandler;
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            return this.entryHandler.handleEntry(entry);
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            return this.entryHandler.handleReference(reference);
        }
    }

    private static class RequestContextImpl<S extends Result, H extends LdapResultHandler<S>>
    implements RequestContext,
    LdapResultHandler<S> {
        protected final H resultHandler;
        private List<CancelRequestListener> cancelRequestListeners;
        private LocalizableMessage cancelRequestReason;
        private List<ExtendedResultHandlerHolder<?>> cancelResultHandlers;
        private final ServerConnectionImpl clientConnection;
        private final boolean isCancelSupported;
        private final int messageID;
        private boolean sendResult = true;
        private RequestState state = RequestState.PENDING;
        private final Object stateLock = new Object();

        protected RequestContextImpl(ServerConnectionImpl clientConnection, H resultHandler, int messageID, boolean isCancelSupported) {
            this.clientConnection = clientConnection;
            this.resultHandler = resultHandler;
            this.messageID = messageID;
            this.isCancelSupported = isCancelSupported;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addCancelRequestListener(CancelRequestListener listener) {
            Reject.ifNull((Object)listener);
            boolean invokeImmediately = false;
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case PENDING: {
                        if (this.cancelRequestListeners == null) {
                            this.cancelRequestListeners = new LinkedList<CancelRequestListener>();
                        }
                        this.cancelRequestListeners.add(listener);
                        break;
                    }
                    case CANCEL_REQUESTED: {
                        invokeImmediately = true;
                        break;
                    }
                }
            }
            if (invokeImmediately) {
                listener.handleCancelRequest(this.cancelRequestReason);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkIfCancelled(boolean signalTooLate) throws CancelledResultException {
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case PENDING: {
                        if (!signalTooLate) break;
                        this.cancelRequestListeners = null;
                        this.state = RequestState.TOO_LATE;
                        break;
                    }
                    case CANCEL_REQUESTED: {
                        throw (CancelledResultException)LdapException.newLdapException(ResultCode.CANCELLED, this.cancelRequestReason.toString());
                    }
                    case TOO_LATE: {
                        break;
                    }
                }
            }
        }

        @Override
        public int getMessageID() {
            return this.messageID;
        }

        @Override
        public void handleException(LdapException error) {
            if (this.clientConnection.removePendingRequest(this)) {
                if (this.setResult(error.getResult())) {
                    // empty if block
                }
                this.resultHandler.handleException(error);
            }
        }

        @Override
        public void handleResult(S result) {
            if (this.clientConnection.removePendingRequest(this)) {
                if (this.setResult((Result)result)) {
                    // empty if block
                }
                this.resultHandler.handleResult(result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeCancelRequestListener(CancelRequestListener listener) {
            Reject.ifNull((Object)listener);
            Object object = this.stateLock;
            synchronized (object) {
                if (this.cancelRequestListeners != null) {
                    this.cancelRequestListeners.remove(listener);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <R extends ExtendedResult> void cancel(LocalizableMessage reason, ExtendedRequest<R> cancelRequest, LdapResultHandler<R> cancelResultHandler, boolean sendResult) {
            Reject.ifNull((Object)reason);
            if (!this.isCancelSupported) {
                if (cancelResultHandler != null) {
                    GenericExtendedResult result = Responses.newGenericExtendedResult(ResultCode.CANNOT_CANCEL);
                    cancelResultHandler.handleException(LdapException.newLdapException(result));
                }
                return;
            }
            List<CancelRequestListener> tmpListeners = null;
            boolean invokeResultHandler = false;
            boolean resultHandlerIsSuccess = false;
            Object object = this.stateLock;
            synchronized (object) {
                switch (this.state) {
                    case PENDING: {
                        this.cancelRequestReason = reason;
                        if (cancelResultHandler != null) {
                            this.cancelResultHandlers = new LinkedList();
                            this.cancelResultHandlers.add(new ExtendedResultHandlerHolder(cancelRequest, cancelResultHandler));
                        }
                        tmpListeners = this.cancelRequestListeners;
                        this.cancelRequestListeners = null;
                        this.state = RequestState.CANCEL_REQUESTED;
                        this.sendResult &= sendResult;
                        break;
                    }
                    case CANCEL_REQUESTED: {
                        if (cancelResultHandler == null) break;
                        if (this.cancelResultHandlers == null) {
                            this.cancelResultHandlers = new LinkedList();
                        }
                        this.cancelResultHandlers.add(new ExtendedResultHandlerHolder(cancelRequest, cancelResultHandler));
                        break;
                    }
                    case TOO_LATE: 
                    case RESULT_SENT: {
                        if (cancelResultHandler == null) break;
                        invokeResultHandler = true;
                        resultHandlerIsSuccess = false;
                        break;
                    }
                    case CANCELLED: {
                        if (cancelResultHandler == null) break;
                        invokeResultHandler = true;
                        resultHandlerIsSuccess = true;
                    }
                }
            }
            if (tmpListeners != null) {
                for (CancelRequestListener listener : tmpListeners) {
                    listener.handleCancelRequest(reason);
                }
            }
            if (invokeResultHandler) {
                GenericExtendedResult result;
                if (resultHandlerIsSuccess) {
                    result = cancelRequest.getResultDecoder().newExtendedErrorResult(ResultCode.SUCCESS, "", "");
                    cancelResultHandler.handleResult(result);
                } else {
                    result = Responses.newGenericExtendedResult(ResultCode.TOO_LATE);
                    cancelResultHandler.handleException(LdapException.newLdapException(result));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setResult(Result result) {
            boolean maySendResult;
            List<ExtendedResultHandlerHolder<?>> tmpHandlers = null;
            boolean isCancelled = false;
            Object object = this.stateLock;
            synchronized (object) {
                maySendResult = this.sendResult;
                switch (this.state) {
                    case PENDING: 
                    case TOO_LATE: {
                        if (!result.getResultCode().equals(ResultCode.CANCELLED)) {
                            this.state = RequestState.RESULT_SENT;
                            break;
                        }
                        this.state = RequestState.CANCELLED;
                        break;
                    }
                    case CANCEL_REQUESTED: {
                        this.state = !result.getResultCode().equals(ResultCode.CANCELLED) ? RequestState.RESULT_SENT : RequestState.CANCELLED;
                        isCancelled = this.state == RequestState.CANCELLED;
                        tmpHandlers = this.cancelResultHandlers;
                        this.cancelResultHandlers = null;
                        break;
                    }
                    case RESULT_SENT: 
                    case CANCELLED: {
                        maySendResult = false;
                    }
                }
            }
            if (tmpHandlers != null) {
                for (ExtendedResultHandlerHolder extendedResultHandlerHolder : tmpHandlers) {
                    if (isCancelled) {
                        extendedResultHandlerHolder.handleSuccess();
                        continue;
                    }
                    extendedResultHandlerHolder.handleTooLate();
                }
            }
            return maySendResult;
        }

        private static enum RequestState {
            CANCEL_REQUESTED,
            CANCELLED,
            PENDING,
            RESULT_SENT,
            TOO_LATE;

        }

        private static final class ExtendedResultHandlerHolder<R extends ExtendedResult> {
            private final ExtendedRequest<R> request;
            private final LdapResultHandler<R> resultHandler;

            private ExtendedResultHandlerHolder(ExtendedRequest<R> request, LdapResultHandler<R> resultHandler) {
                this.request = request;
                this.resultHandler = resultHandler;
            }

            private void handleSuccess() {
                R cancelResult = this.request.getResultDecoder().newExtendedErrorResult(ResultCode.SUCCESS, "", "");
                this.resultHandler.handleResult(cancelResult);
            }

            private void handleTooLate() {
                R cancelResult = this.request.getResultDecoder().newExtendedErrorResult(ResultCode.TOO_LATE, "", "");
                this.resultHandler.handleException(LdapException.newLdapException(cancelResult));
            }
        }
    }
}

